/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.handlers.ClientHandler;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class YetaWrenchOverlayRenderer {
    private ConduitDisplayMode cachedMode = ConduitDisplayMode.ALL;
    private int displayTickCount;
    private long lastTick;

    public YetaWrenchOverlayRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        ItemStack equippedWrench = this.getEquippedWrench();
        if (equippedWrench != null && event.type == RenderGameOverlayEvent.ElementType.ALL) {
            this.doRenderOverlay(event, equippedWrench);
        }
    }

    private ItemStack getEquippedWrench() {
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped != null && equipped.getItem() instanceof IConduitControl) {
            return ((IConduitControl)equipped.getItem()).showOverlay(equipped, (EntityPlayer)player) ? equipped : null;
        }
        return null;
    }

    private void doRenderOverlay(RenderGameOverlayEvent event, ItemStack equippedWrench) {
        ConduitDisplayMode mode = ConduitDisplayMode.getDisplayMode(equippedWrench);
        if (mode != this.cachedMode) {
            this.cachedMode = mode;
            this.displayTickCount = 20;
            this.lastTick = ClientHandler.getTicksElapsed();
        }
        ScaledResolution res = event.resolution;
        Tessellator tess = Tessellator.instance;
        int modeCount = ConduitDisplayMode.registrySize();
        Iterable<ConduitDisplayMode> renderable = ConduitDisplayMode.getRenderableModes();
        switch (Config.yetaWrenchOverlayMode) {
            case 0: {
                if (this.displayTickCount > 0) {
                    if (this.lastTick < (long)ClientHandler.getTicksElapsed()) {
                        ++this.lastTick;
                        --this.displayTickCount;
                    }
                    int x = res.getScaledWidth() / 2 - 8;
                    int y = res.getScaledHeight() / 2 - 24;
                    IWidgetIcon widget = mode.getWidgetSelected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    widget.getMap().render(widget, (double)x, (double)y, true);
                    int size = 12;
                    widget = mode.previous().getWidgetSelected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    widget.getMap().render(widget, (double)(x - 18 + (16 - size)), (double)(y + (16 - size)), (double)size, (double)size, 0.0, true);
                    widget = mode.next().getWidgetSelected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    widget.getMap().render(widget, (double)(x + 18), (double)(y + (16 - size)), (double)size, (double)size, 0.0, true);
                    break;
                }
                int x = res.getScaledWidth() - 20;
                int y = res.getScaledHeight() - 20;
                IWidgetIcon widget = mode.getWidgetSelected();
                RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                widget.getMap().render(widget, (double)x, (double)y, true);
                break;
            }
            case 1: {
                int size = 16;
                int padding = 2;
                int inset = (int)((double)size / 1.5);
                int offsetX = res.getScaledWidth() - inset - 1;
                int offsetY = res.getScaledHeight() - modeCount * (size + padding) - padding;
                inset = size - inset;
                int x = offsetX + 2;
                int y = offsetY - padding * 2;
                int height = modeCount * (size + padding) + padding * 3;
                GL11.glDisable((int)3553);
                GL11.glShadeModel((int)7425);
                tess.startDrawingQuads();
                tess.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.2f);
                tess.addVertex((double)x, (double)y, -5.0);
                tess.addVertex((double)x, (double)(y + height), -5.0);
                Vector4f color = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                tess.setColorRGBA_F(color.x, color.y, color.z, color.w);
                tess.addVertex((double)(x + size), (double)(y + height), -5.0);
                tess.addVertex((double)(x + size), (double)y, -5.0);
                tess.draw();
                tess.setColorOpaque_I(0xFFFFFF);
                GL11.glShadeModel((int)7424);
                y += padding * 2;
                x -= 2;
                if (mode == ConduitDisplayMode.ALL) {
                    x -= inset;
                }
                GL11.glEnable((int)3553);
                tess.startDrawingQuads();
                for (ConduitDisplayMode toRender : renderable) {
                    IWidgetIcon widget = mode == ConduitDisplayMode.ALL ? toRender.getWidgetSelected() : toRender.getWidgetUnselected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    if (toRender == mode) {
                        widget = toRender.getWidgetSelected();
                        widget.getMap().render(widget, (double)(x - inset), (double)y);
                    } else {
                        widget.getMap().render(widget, (double)x, (double)y);
                    }
                    y += size + padding;
                }
                tess.draw();
                break;
            }
            case 2: {
                int offsetX = res.getScaledWidth() - modeCount * 8 - 16;
                int y = res.getScaledHeight() - 40;
                int x = offsetX;
                if (modeCount % 2 == 1) {
                    x += 8;
                }
                int count = 0;
                tess.startDrawingQuads();
                for (ConduitDisplayMode toRender : renderable) {
                    IWidgetIcon widget = mode == ConduitDisplayMode.ALL || toRender == mode ? toRender.getWidgetSelected() : toRender.getWidgetUnselected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    widget.getMap().render(widget, (double)x, (double)y);
                    x += 16;
                    if (count == modeCount / 2 - 1) {
                        x = offsetX;
                        y += 16;
                    }
                    ++count;
                }
                tess.draw();
            }
        }
    }
}

