/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import crazypants.enderio.item.PacketMagnetState;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.BaublesUtil;
import crazypants.util.BotaniaUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class MagnetController {
    private static final double collisionDistanceSq = 1.5625;
    private static final double speed = 0.035;
    private static final double speed4 = 0.14;
    private static List<Item> blacklist = null;

    public MagnetController() {
        PacketHandler.INSTANCE.registerMessage(PacketMagnetState.class, PacketMagnetState.class, PacketHandler.nextID(), Side.SERVER);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ActiveMagnet mag = this.getActiveMagnet(event.player);
        if (mag != null && event.player.getHealth() > 0.0f) {
            this.doHoover(event.player);
            if (event.side == Side.SERVER && event.player.worldObj.getTotalWorldTime() % 20L == 0L) {
                ItemMagnet.drainPerSecondPower(mag.item);
                event.player.inventory.setInventorySlotContents(mag.slot, mag.item);
                event.player.inventory.markDirty();
            }
        }
    }

    private ActiveMagnet getActiveMagnet(EntityPlayer player) {
        ItemStack[] inv = player.inventory.mainInventory;
        int maxSlot = Config.magnetAllowInMainInventory ? 36 : 9;
        for (int i = 0; i < maxSlot; ++i) {
            if (!ItemMagnet.isActive(inv[i]) || !ItemMagnet.hasPower(inv[i])) continue;
            return new ActiveMagnet(inv[i], i);
        }
        return null;
    }

    public void doHoover(EntityPlayer player) {
        AxisAlignedBB aabb;
        List<Entity> interestingItems;
        if (blacklist == null) {
            MagnetController.initBlacklist();
        }
        if ((interestingItems = this.selectEntitiesWithinAABB(player.worldObj, aabb = AxisAlignedBB.getBoundingBox((double)(player.posX - (double)Config.magnetRange), (double)(player.posY - (double)Config.magnetRange), (double)(player.posZ - (double)Config.magnetRange), (double)(player.posX + (double)Config.magnetRange), (double)(player.posY + (double)Config.magnetRange), (double)(player.posZ + (double)Config.magnetRange)))) != null) {
            for (Entity entity : interestingItems) {
                double x = player.posX + 0.5 - entity.posX;
                double y = player.posY + 1.0 - entity.posY;
                double z = player.posZ + 0.5 - entity.posZ;
                double distance = x * x + y * y + z * z;
                if (distance < 1.5625) {
                    entity.onCollideWithPlayer(player);
                    continue;
                }
                double distancespeed = 0.14 / distance;
                entity.motionX += x * distancespeed;
                entity.motionY = y > 0.0 ? 0.12 : (entity.motionY += y * 0.035);
                entity.motionZ += z * distancespeed;
            }
        }
    }

    private static void initBlacklist() {
        blacklist = new ArrayList<Item>();
        for (String name : Config.magnetBlacklist) {
            Item item;
            String[] parts = name.split(":");
            if (parts.length != 2 || (item = GameRegistry.findItem((String)parts[0], (String)parts[1])) == null) continue;
            blacklist.add(item);
        }
    }

    private List<Entity> selectEntitiesWithinAABB(World world, AxisAlignedBB bb) {
        ArrayList<Entity> arraylist = null;
        int itemsRemaining = Config.magnetMaxItems;
        if (itemsRemaining <= 0) {
            itemsRemaining = Integer.MAX_VALUE;
        }
        int minChunkX = MathHelper.floor_double((double)(bb.minX / 16.0));
        int maxChunkX = MathHelper.floor_double((double)(bb.maxX / 16.0));
        int minChunkZ = MathHelper.floor_double((double)(bb.minZ / 16.0));
        int maxChunkZ = MathHelper.floor_double((double)(bb.maxZ / 16.0));
        int minChunkY = MathHelper.floor_double((double)(bb.minY / 16.0));
        int maxChunkY = MathHelper.floor_double((double)(bb.maxY / 16.0));
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                Chunk chunk = world.getChunkFromChunkCoords(chunkX, chunkZ);
                int minChunkYClamped = MathHelper.clamp_int((int)minChunkY, (int)0, (int)(chunk.entityLists.length - 1));
                int maxChunkYClamped = MathHelper.clamp_int((int)maxChunkY, (int)0, (int)(chunk.entityLists.length - 1));
                for (int chunkY = minChunkYClamped; chunkY <= maxChunkYClamped; ++chunkY) {
                    for (Entity entity : chunk.entityLists[chunkY]) {
                        if (entity.isDead) continue;
                        boolean gotOne = false;
                        if (entity instanceof EntityItem && entity.boundingBox.intersectsWith(bb)) {
                            boolean bl = gotOne = !BotaniaUtil.hasSolegnoliaAround(entity);
                            if (gotOne && !blacklist.isEmpty()) {
                                Item item = ((EntityItem)entity).getEntityItem().getItem();
                                for (Item blacklisted : blacklist) {
                                    if (blacklisted != item) continue;
                                    gotOne = false;
                                    break;
                                }
                            }
                        } else if (entity instanceof EntityXPOrb && entity.boundingBox.intersectsWith(bb)) {
                            gotOne = true;
                        }
                        if (!gotOne) continue;
                        if (arraylist == null) {
                            arraylist = new ArrayList<Entity>(Config.magnetMaxItems > 0 ? Config.magnetMaxItems : 20);
                        }
                        arraylist.add(entity);
                        if (itemsRemaining-- > 0) continue;
                        return arraylist;
                    }
                }
            }
        }
        return arraylist;
    }

    public static void setMagnetActive(EntityPlayerMP player, PacketMagnetState.SlotType type, int slot, boolean isActive) {
        ItemStack stack = null;
        IInventory baubles = null;
        int dropOff = -1;
        switch (type) {
            case INVENTORY: {
                stack = player.inventory.getStackInSlot(slot);
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles == null) break;
                stack = baubles.getStackInSlot(slot);
            }
        }
        if (stack == null || stack.getItem() == null || stack.getItem() != DarkSteelItems.itemMagnet || ItemMagnet.isActive(stack) == isActive) {
            return;
        }
        if (!Config.magnetAllowDeactivatedInBaublesSlot && type == PacketMagnetState.SlotType.BAUBLES && !isActive) {
            ItemStack[] inv = player.inventory.mainInventory;
            for (int i = 0; i < inv.length && dropOff < 0; ++i) {
                if (inv[i] != null) continue;
                dropOff = i;
            }
            if (dropOff < 0) {
                return;
            }
        }
        ItemMagnet.setActive(stack, isActive);
        switch (type) {
            case INVENTORY: {
                player.inventory.setInventorySlotContents(slot, stack);
                player.inventory.markDirty();
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                if (dropOff < 0) {
                    baubles.setInventorySlotContents(slot, stack);
                } else {
                    baubles.setInventorySlotContents(slot, null);
                    player.inventory.setInventorySlotContents(dropOff, stack);
                }
                player.inventory.markDirty();
            }
        }
    }

    private static class ActiveMagnet {
        ItemStack item;
        int slot;

        ActiveMagnet(ItemStack item, int slot) {
            this.item = item;
            this.slot = slot;
        }
    }
}

