/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.ChatUtil;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import crazypants.enderio.item.PacketConduitProbeMode;
import crazypants.enderio.item.PacketMagnetState;
import crazypants.enderio.item.YetaWrenchPacketProcessor;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.SoundDetector;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SoundDetectorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.thaumcraft.GogglesOfRevealingUpgrade;
import crazypants.util.BaublesUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class KeyTracker {
    public static final KeyTracker instance = new KeyTracker();
    private final KeyBinding glideKey = new KeyBinding(EnderIO.lang.localize("keybind.glidertoggle"), 34, EnderIO.lang.localize("category.darksteelarmor"));
    private final KeyBinding soundDetectorKey;
    private final KeyBinding nightVisionKey;
    private final KeyBinding stepAssistKey;
    private final KeyBinding speedKey;
    private final KeyBinding jumpKey;
    private final KeyBinding gogglesKey;
    private final KeyBinding yetaWrenchMode;
    private final KeyBinding magnetKey;

    public KeyTracker() {
        ClientRegistry.registerKeyBinding((KeyBinding)this.glideKey);
        this.soundDetectorKey = new KeyBinding(EnderIO.lang.localize("keybind.soundlocator"), 38, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.soundDetectorKey);
        this.nightVisionKey = new KeyBinding(EnderIO.lang.localize("keybind.nightvision"), 25, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.nightVisionKey);
        this.gogglesKey = new KeyBinding(EnderIO.lang.localize("keybind.gogglesofrevealing"), 19, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.gogglesKey);
        this.stepAssistKey = new KeyBinding(EnderIO.lang.localize("keybind.stepassist"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepAssistKey);
        this.speedKey = new KeyBinding(EnderIO.lang.localize("keybind.speed"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.speedKey);
        this.jumpKey = new KeyBinding(EnderIO.lang.localize("keybind.jump"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.jumpKey);
        this.yetaWrenchMode = new KeyBinding(EnderIO.lang.localize("keybind.yetawrenchmode"), 21, EnderIO.lang.localize("category.tools"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.yetaWrenchMode);
        this.magnetKey = new KeyBinding(EnderIO.lang.localize("keybind.magnet"), 0, EnderIO.lang.localize("category.tools"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.magnetKey);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.handleGlide();
        this.handleSoundDetector();
        this.handleNightVision();
        this.handleYetaWrench();
        this.handleGoggles();
        this.handleStepAssist();
        this.handleSpeed();
        this.handleJump();
        this.handleMagnet();
    }

    private void sendEnabledChatMessage(String messageBase, boolean isActive) {
        String message = messageBase.concat(isActive ? ".enabled" : ".disabled");
        ChatUtil.sendNoSpamClientUnloc((Lang)EnderIO.lang, (String[])new String[]{message});
    }

    private void toggleDarkSteelController(PacketUpgradeState.Type type, String messageBase) {
        boolean isActive = !DarkSteelController.instance.isActive((EntityPlayer)Minecraft.getMinecraft().thePlayer, type);
        this.sendEnabledChatMessage(messageBase, isActive);
        DarkSteelController.instance.setActive((EntityPlayer)Minecraft.getMinecraft().thePlayer, type, isActive);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(type, isActive));
    }

    private void handleMagnet() {
        if (this.magnetKey.isPressed()) {
            EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
            ItemStack[] inv = player.inventory.mainInventory;
            for (int i = 0; i < 9; ++i) {
                if (inv[i] == null || inv[i].getItem() == null || inv[i].getItem() != DarkSteelItems.itemMagnet) continue;
                boolean isActive = !ItemMagnet.isActive(inv[i]);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.INVENTORY, i, isActive));
                return;
            }
            IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
            if (baubles != null) {
                for (int i = 0; i < baubles.getSizeInventory(); ++i) {
                    ItemStack stack = baubles.getStackInSlot(i);
                    if (stack == null || stack.getItem() == null || stack.getItem() != DarkSteelItems.itemMagnet) continue;
                    boolean isActive = !ItemMagnet.isActive(stack);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.BAUBLES, i, isActive));
                    return;
                }
            }
        }
    }

    private void handleJump() {
        if (!JumpUpgrade.isEquipped((EntityPlayer)Minecraft.getMinecraft().thePlayer)) {
            return;
        }
        if (this.jumpKey.isPressed()) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.JUMP, "darksteel.upgrade.jump");
        }
    }

    private void handleSpeed() {
        if (!SpeedUpgrade.isEquipped((EntityPlayer)Minecraft.getMinecraft().thePlayer)) {
            return;
        }
        if (this.speedKey.isPressed()) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.SPEED, "darksteel.upgrade.speed");
        }
    }

    private void handleStepAssist() {
        if (!JumpUpgrade.isEquipped((EntityPlayer)Minecraft.getMinecraft().thePlayer)) {
            return;
        }
        if (this.stepAssistKey.isPressed()) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.STEP_ASSIST, "darksteel.upgrade.stepAssist");
        }
    }

    private void handleGoggles() {
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        if (!GogglesOfRevealingUpgrade.isUpgradeEquipped((EntityPlayer)player)) {
            return;
        }
        if (this.gogglesKey.isPressed()) {
            boolean isActive = !DarkSteelItems.itemDarkSteelHelmet.isGogglesUgradeActive();
            this.sendEnabledChatMessage("darksteel.upgrade.goggles", isActive);
            DarkSteelItems.itemDarkSteelHelmet.setGogglesUgradeActive(isActive);
        }
    }

    private void handleYetaWrench() {
        if (!this.yetaWrenchMode.isPressed()) {
            if (this.yetaWrenchMode.getKeyCode() == 0) {
                Config.checkYetaAccess();
            }
            return;
        }
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null) {
            return;
        }
        if (equipped.getItem() instanceof IConduitControl) {
            ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
            if (curMode == null) {
                curMode = ConduitDisplayMode.ALL;
            }
            ConduitDisplayMode newMode = player.isSneaking() ? curMode.previous() : curMode.next();
            ConduitDisplayMode.setDisplayMode(equipped, newMode);
            PacketHandler.INSTANCE.sendToServer((IMessage)new YetaWrenchPacketProcessor(player.inventory.currentItem, newMode));
        } else if (equipped.getItem() == EnderIO.itemConduitProbe) {
            int newMeta = equipped.getItemDamage() == 0 ? 1 : 0;
            equipped.setItemDamage(newMeta);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbeMode());
            player.swingItem();
        }
    }

    private void handleSoundDetector() {
        if (!this.isSoundDetectorUpgradeEquipped(Minecraft.getMinecraft().thePlayer)) {
            SoundDetector.instance.setEnabled(false);
            return;
        }
        if (this.soundDetectorKey.isPressed()) {
            boolean isActive = !SoundDetector.instance.isEnabled();
            this.sendEnabledChatMessage("darksteel.upgrade.sound", isActive);
            SoundDetector.instance.setEnabled(isActive);
        }
    }

    private void handleGlide() {
        if (!DarkSteelController.instance.isGliderUpgradeEquipped((EntityPlayer)Minecraft.getMinecraft().thePlayer)) {
            return;
        }
        if (this.glideKey.isPressed()) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.GLIDE, "darksteel.upgrade.glider");
        }
    }

    private void handleNightVision() {
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        if (!DarkSteelController.instance.isNightVisionUpgradeEquipped((EntityPlayer)player)) {
            return;
        }
        if (this.nightVisionKey.isPressed()) {
            boolean isActive;
            boolean bl = isActive = !DarkSteelController.instance.isNightVisionActive();
            if (isActive) {
                player.worldObj.playSound(player.posX, player.posY, player.posZ, EnderIO.DOMAIN + ":ds.nightvision.on", 0.1f, player.worldObj.rand.nextFloat() * 0.4f - 0.2f + 1.0f, false);
            } else {
                player.worldObj.playSound(player.posX, player.posY, player.posZ, EnderIO.DOMAIN + ":ds.nightvision.off", 0.1f, 1.0f, false);
            }
            DarkSteelController.instance.setNightVisionActive(isActive);
        }
    }

    public boolean isSoundDetectorUpgradeEquipped(EntityClientPlayerMP player) {
        ItemStack helmet = player.getEquipmentInSlot(4);
        SoundDetectorUpgrade upgrade = SoundDetectorUpgrade.loadFromItem(helmet);
        return upgrade != null;
    }

    public KeyBinding getYetaWrenchMode() {
        return this.yetaWrenchMode;
    }
}

