/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cofh.api.energy.ItemEnergyContainer;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.MagnetController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.util.BaublesUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles|API")
public class ItemMagnet
extends ItemEnergyContainer
implements IResourceTooltipProvider,
IBauble {
    private static final String ACTIVE_KEY = "magnetActive";
    static MagnetController controller = new MagnetController();

    public static void setActive(ItemStack item, boolean active) {
        if (item == null) {
            return;
        }
        NBTTagCompound nbt = ItemUtil.getOrCreateNBT((ItemStack)item);
        nbt.setBoolean(ACTIVE_KEY, active);
    }

    public static boolean isActive(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.stackTagCompound == null) {
            return false;
        }
        if (!item.stackTagCompound.hasKey(ACTIVE_KEY)) {
            return false;
        }
        return item.stackTagCompound.getBoolean(ACTIVE_KEY);
    }

    public static boolean hasPower(ItemStack itemStack) {
        int energyStored = DarkSteelItems.itemMagnet.getEnergyStored(itemStack);
        return energyStored > 0 && energyStored >= Config.magnetPowerUsePerSecondRF;
    }

    public static void drainPerSecondPower(ItemStack itemStack) {
        DarkSteelItems.itemMagnet.extractEnergyInternal(itemStack, Config.magnetPowerUsePerSecondRF, false);
    }

    public static ItemMagnet create() {
        ItemMagnet result = new ItemMagnet();
        result.init();
        FMLCommonHandler.instance().bus().register((Object)controller);
        return result;
    }

    protected ItemMagnet() {
        super(Config.magnetPowerCapacityRF, Config.magnetPowerCapacityRF / 100);
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemMagnet.unlocalisedName);
        this.setMaxDamage(16);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemMagnet.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister IIconRegister2) {
        this.itemIcon = IIconRegister2.registerIcon("enderio:magnet");
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        this.setFull(is);
        par3List.add(is);
        is = new ItemStack((Item)this);
        this.setEnergy(is, 0);
        par3List.add(is);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, par2EntityPlayer, list, par4);
        String str = PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(this.getMaxEnergyStored(itemStack)) + " " + PowerDisplayUtil.abrevation();
        list.add(str);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack item, int pass) {
        return ItemMagnet.isActive(item);
    }

    public void onCreated(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergy(itemStack, 0);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int res = super.receiveEnergy(container, maxReceive, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (Config.magnetAllowPowerExtraction) {
            return this.extractEnergyInternal(container, maxExtract, simulate);
        }
        return 0;
    }

    public int extractEnergyInternal(ItemStack container, int maxExtract, boolean simulate) {
        int res = super.extractEnergy(container, maxExtract, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    void setEnergy(ItemStack container, int energy) {
        if (container.stackTagCompound == null) {
            container.stackTagCompound = new NBTTagCompound();
        }
        container.stackTagCompound.setInteger("Energy", energy);
        this.updateDamage(container);
    }

    void setFull(ItemStack container) {
        this.setEnergy(container, Config.magnetPowerCapacityRF);
    }

    private void updateDamage(ItemStack stack) {
        float r = (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack);
        int res = 16 - (int)(r * 16.0f);
        stack.setItemDamage(res);
    }

    public ItemStack onItemRightClick(ItemStack equipped, World world, EntityPlayer player) {
        if (player.isSneaking()) {
            ItemMagnet.setActive(equipped, !ItemMagnet.isActive(equipped));
        }
        return equipped;
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.getUnlocalizedName();
    }

    @Optional.Method(modid="Baubles|API")
    public BaubleType getBaubleType(ItemStack itemstack) {
        BaubleType t = null;
        try {
            t = BaubleType.valueOf((String)Config.magnetBaublesType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t != null ? t : BaubleType.AMULET;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && ItemMagnet.isActive(itemstack) && ItemMagnet.hasPower(itemstack) && ((EntityPlayer)player).getHealth() > 0.0f) {
            controller.doHoover((EntityPlayer)player);
            if (!player.worldObj.isRemote && player.worldObj.getTotalWorldTime() % 20L == 0L) {
                ItemMagnet.drainPerSecondPower(itemstack);
                IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles != null) {
                    baubles.markDirty();
                }
            }
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return Config.magnetAllowInBaublesSlot && (Config.magnetAllowDeactivatedInBaublesSlot || ItemMagnet.isActive(itemstack));
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

