/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ItemEnderFood
extends ItemFood
implements IResourceTooltipProvider {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    @SideOnly(value=Side.CLIENT)
    private SpecialFont fr;

    public static ItemEnderFood create() {
        ItemEnderFood ret = new ItemEnderFood();
        GameRegistry.registerItem((Item)ret, (String)ModObject.itemEnderFood.unlocalisedName);
        return ret;
    }

    public ItemEnderFood() {
        super(0, false);
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
    }

    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (EnderFood f : EnderFood.VALUES) {
            list.add(f.getStack());
        }
    }

    public String getUnlocalizedName(ItemStack p_77667_1_) {
        return "enderio." + EnderFood.get((ItemStack)p_77667_1_).unlocalisedName;
    }

    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[EnderFood.VALUES.length];
        for (EnderFood f : EnderFood.VALUES) {
            this.icons[f.ordinal()] = register.registerIcon("enderio:" + f.unlocalisedName);
        }
    }

    public IIcon getIconFromDamage(int damage) {
        return this.icons[damage % this.icons.length];
    }

    public int func_150905_g(ItemStack p_150905_1_) {
        return EnderFood.get((ItemStack)p_150905_1_).hunger;
    }

    public float func_150906_h(ItemStack p_150906_1_) {
        return EnderFood.get((ItemStack)p_150906_1_).saturation;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        if (this.fr == null) {
            this.fr = new SpecialFont(Minecraft.getMinecraft().fontRenderer);
        }
        return this.fr;
    }

    public static enum EnderFood {
        ENDERIOS("itemEnderios", 10, 0.8f);

        public final String unlocalisedName;
        public final int hunger;
        public final float saturation;
        public static final EnderFood[] VALUES;

        private EnderFood(String name, int hunger, float saturation) {
            this.unlocalisedName = name;
            this.hunger = hunger;
            this.saturation = saturation;
        }

        public ItemStack getStack() {
            return this.getStack(1);
        }

        public ItemStack getStack(int size) {
            return new ItemStack((Item)EnderIO.itemEnderFood, size, this.ordinal());
        }

        public static EnderFood get(ItemStack stack) {
            return VALUES[stack.getItemDamage() % VALUES.length];
        }

        static {
            VALUES = EnderFood.values();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class SpecialFont
    extends FontRenderer {
        private FontRenderer wrapped;
        private ItemStack stack;
        private int inARow;

        public SpecialFont(FontRenderer wrapped) {
            super(Minecraft.getMinecraft().gameSettings, new ResourceLocation("textures/font/ascii.png"), Minecraft.getMinecraft().renderEngine, false);
            this.stack = EnderFood.ENDERIOS.getStack();
            this.inARow = 0;
            this.wrapped = wrapped;
        }

        public int drawString(String string, int x, int y, int color, boolean p_85187_5_) {
            boolean pop = false;
            if (this.isSmallText(string)) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslated((double)x, (double)y, (double)0.0);
                GL11.glTranslated((double)0.0, (double)(-this.FONT_HEIGHT * this.inARow + this.FONT_HEIGHT), (double)0.0);
                ++this.inARow;
                pop = true;
            } else {
                this.inARow = 0;
            }
            int ret = this.wrapped.drawString(string, x, y, color, p_85187_5_);
            if (pop) {
                GL11.glPopMatrix();
            }
            return ret;
        }

        public int getStringWidth(String p_78256_1_) {
            int ret = this.wrapped.getStringWidth(p_78256_1_);
            if (this.isSmallText(p_78256_1_)) {
                ret /= 2;
            }
            return ret;
        }

        private boolean isSmallText(String string) {
            ArrayList lines = Lists.newArrayList();
            SpecialTooltipHandler.addDetailedTooltipFromResources((List)lines, (String)ItemEnderFood.this.getUnlocalizedNameForTooltip(this.stack));
            return lines.contains(EnumChatFormatting.getTextWithoutFormattingCodes((String)string));
        }

        public int getCharWidth(char p_78263_1_) {
            return this.wrapped.getCharWidth(p_78263_1_);
        }
    }
}

