/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.entity;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.entity.EntityWitherSkeleton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class SkeletonHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void skeletonJoinWorld(LivingSpawnEvent event) {
        if (!event.world.isRemote && this.isWitherSkele(event.entity)) {
            event.entity.setDead();
            event.world.spawnEntityInWorld((Entity)new EntityWitherSkeleton((EntitySkeleton)event.entity));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void skeletonJoinWorld(EntityJoinWorldEvent event) {
        if (!event.world.isRemote && this.isWitherSkele(event.entity) && !event.entity.isDead) {
            event.setCanceled(true);
            event.world.spawnEntityInWorld((Entity)new EntityWitherSkeleton((EntitySkeleton)event.entity));
        }
    }

    private boolean isWitherSkele(Entity entity) {
        return entity.getClass() == EntitySkeleton.class && ((EntitySkeleton)entity).getSkeletonType() == 1;
    }

    public static void registerSkeleton(EnderIO mod) {
        int entityID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityWitherSkeleton.class, (String)"witherSkeleton", (int)entityID, (int)61, (int)7674183);
        EntityRegistry.registerModEntity(EntityWitherSkeleton.class, (String)"witherSkeleton", (int)entityID, (Object)mod, (int)64, (int)3, (boolean)true);
        MinecraftForge.EVENT_BUS.register((Object)new SkeletonHandler());
    }
}

