/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.entity;

import com.enderio.core.common.util.EntityUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Calendar;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityWitherSkeleton
extends EntitySkeleton {
    public EntityWitherSkeleton(World world) {
        super(world);
    }

    public EntityWitherSkeleton(EntitySkeleton entity) {
        this(entity.worldObj);
        this.copyLocationAndAnglesFrom((Entity)entity);
        for (int i = 0; i < entity.getLastActiveItems().length; ++i) {
            this.setCurrentItemOrArmor(i, entity.getEquipmentInSlot(i));
        }
    }

    public void setFire(int p_70015_1_) {
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData entityData) {
        Calendar calendar;
        this.getEntityAttribute(SharedMonsterAttributes.followRange).applyModifier(new AttributeModifier("Random spawn bonus", this.rand.nextGaussian() * 0.05, 1));
        this.setSkeletonType(1);
        this.setCurrentItemOrArmor(0, new ItemStack(Items.stone_sword));
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
        this.setCombatTask();
        this.setCanPickUpLoot(this.rand.nextFloat() < 0.55f * this.worldObj.func_147462_b(this.posX, this.posY, this.posZ));
        if (this.getEquipmentInSlot(4) == null && (calendar = this.worldObj.getCurrentDate()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.rand.nextFloat() < 0.25f) {
            this.setCurrentItemOrArmor(4, new ItemStack(this.rand.nextFloat() < 0.1f ? Blocks.lit_pumpkin : Blocks.pumpkin));
            this.equipmentDropChances[4] = 0.0f;
        }
        return entityData;
    }

    public int getSkeletonType() {
        return 1;
    }

    public void onDeath(DamageSource source) {
        Item necroticBone;
        int lootingLevel;
        EntityPlayer player;
        ItemStack stack;
        super.onDeath(source);
        if (source.damageType.equals("player") && (stack = (player = (EntityPlayer)source.getEntity()).getCurrentEquippedItem()) != null && stack.hasTagCompound()) {
            Item cleaver = GameRegistry.findItem((String)"TConstruct", (String)"cleaver");
            int beheading = stack.getTagCompound().getCompoundTag("InfiTool").getInteger("Beheading");
            if (stack.getItem() == cleaver) {
                beheading += 2;
            }
            if (beheading > 0 && this.worldObj.rand.nextInt(100) < beheading * 10) {
                EntityUtil.spawnItemInWorldWithRandomMotion((World)this.worldObj, (ItemStack)new ItemStack(Items.skull, 1, 1), (double)this.posX, (double)this.posY, (double)this.posZ);
            }
        }
        if (source.getEntity() instanceof EntityLivingBase && this.worldObj.rand.nextInt(Math.max(1, 1 - (lootingLevel = EnchantmentHelper.getLootingModifier((EntityLivingBase)((EntityLivingBase)source.getEntity()))))) == 0 && (necroticBone = GameRegistry.findItem((String)"TConstruct", (String)"materials")) != null) {
            EntityUtil.spawnItemInWorldWithRandomMotion((World)this.worldObj, (ItemStack)new ItemStack(necroticBone, 1, 8), (double)this.posX, (double)this.posY, (double)this.posZ);
        }
    }
}

