/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enchantment;

import com.enderio.core.api.common.enchant.IAdvancedEnchant;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.util.BaublesUtil;
import crazypants.util.GalacticraftUtil;
import java.util.ListIterator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EnchantmentSoulBound
extends Enchantment
implements IAdvancedEnchant {
    private final int id;

    public static EnchantmentSoulBound create(int id) {
        EnchantmentSoulBound res = new EnchantmentSoulBound(id);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    private EnchantmentSoulBound(int id) {
        super(id, Config.enchantmentSoulBoundWeight, EnumEnchantmentType.all);
        this.id = id;
        this.setName("enderio.soulBound");
    }

    public int getMaxEnchantability(int level) {
        return super.getMaxEnchantability(level) + 30;
    }

    public int getMinEnchantability(int level) {
        return super.getMinEnchantability(level);
    }

    public int getMaxLevel() {
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDropsEvent evt) {
        IInventory galacticraft;
        if (evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer || evt.isCanceled()) {
            return;
        }
        if (evt.entityPlayer.worldObj.getGameRules().getGameRuleBooleanValue("keepInventory")) {
            return;
        }
        ListIterator iter = evt.drops.listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack item = ei.getEntityItem();
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
            iter.remove();
        }
        IInventory baubles = BaublesUtil.instance().getBaubles(evt.entityPlayer);
        if (baubles != null) {
            for (int i = 0; i < baubles.getSizeInventory(); ++i) {
                ItemStack item = baubles.getStackInSlot(i);
                if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
                baubles.setInventorySlotContents(i, null);
            }
        }
        if (evt.entityPlayer instanceof EntityPlayerMP && (galacticraft = GalacticraftUtil.getGCInventoryForPlayer((EntityPlayerMP)evt.entityPlayer)) != null) {
            for (int i = 0; i < galacticraft.getSizeInventory(); ++i) {
                ItemStack item = galacticraft.getStackInSlot(i);
                if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
                galacticraft.setInventorySlotContents(i, null);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        ItemStack item;
        int i;
        if (!evt.wasDeath || evt.isCanceled()) {
            return;
        }
        if (evt.original == null || evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer) {
            return;
        }
        if (evt.entityPlayer.worldObj.getGameRules().getGameRuleBooleanValue("keepInventory")) {
            return;
        }
        for (i = 0; i < evt.original.inventory.mainInventory.length; ++i) {
            item = evt.original.inventory.mainInventory[i];
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
            evt.original.inventory.mainInventory[i] = null;
        }
        for (i = 0; i < evt.original.inventory.armorInventory.length; ++i) {
            item = evt.original.inventory.armorInventory[i];
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
            evt.original.inventory.armorInventory[i] = null;
        }
    }

    private boolean isSoulBound(ItemStack item) {
        return EnchantmentHelper.getEnchantmentLevel((int)this.id, (ItemStack)item) > 0;
    }

    private boolean addToPlayerInventory(EntityPlayer entityPlayer, ItemStack item) {
        if (item == null || entityPlayer == null) {
            return false;
        }
        if (item.getItem() instanceof ItemArmor) {
            ItemArmor arm = (ItemArmor)item.getItem();
            int index = 3 - arm.armorType;
            if (entityPlayer.inventory.armorItemInSlot(index) == null) {
                entityPlayer.inventory.armorInventory[index] = item;
                return true;
            }
        }
        InventoryPlayer inv = entityPlayer.inventory;
        for (int i = 0; i < inv.mainInventory.length; ++i) {
            if (inv.mainInventory[i] != null) continue;
            inv.mainInventory[i] = item.copy();
            return true;
        }
        return false;
    }

    public String[] getTooltipDetails(ItemStack stack) {
        return new String[]{EnderIO.lang.localizeExact("description.enchantment.enderio.soulBound")};
    }
}

