/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemConduitRenderer
implements IItemRenderer {
    private final BoundingBox bb;

    public ItemConduitRenderer() {
        float scale = 0.8f;
        this.bb = BoundingBox.UNIT_CUBE.scale(scale, scale, scale);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderBlocks = (RenderBlocks)data[0];
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
            this.renderToInventory(item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            this.renderEquipped(item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderEntity(item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)0.3f, (float)0.2f, (float)0.0f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            this.renderEntity(item, renderBlocks);
        } else {
            System.out.println("ItemConduitRenderer.renderItem: Unsupported render type");
        }
    }

    private void renderEntity(ItemStack item, RenderBlocks renderBlocks) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderToInventory(item, renderBlocks);
        GL11.glPopMatrix();
    }

    private void renderEquipped(ItemStack item, RenderBlocks renderBlocks) {
        this.renderToInventory(item, renderBlocks);
    }

    private void renderToInventory(ItemStack item, RenderBlocks renderBlocks) {
        Tessellator.instance.startDrawingQuads();
        CubeRenderer.render((BoundingBox)this.bb, (IIcon)item.getItem().getIconFromDamage(item.getItemDamage()));
        Tessellator.instance.draw();
    }
}

