/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import crazypants.enderio.Log;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduit.power.PowerTracker;
import crazypants.enderio.config.Config;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.IPowerStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class NetworkPowerManager {
    private final PowerConduitNetwork network;
    int maxEnergyStored;
    int energyStored;
    private int updateRenderTicks = 10;
    private int inactiveTicks = 100;
    private final List<PowerConduitNetwork.ReceptorEntry> receptors = new ArrayList<PowerConduitNetwork.ReceptorEntry>();
    private ListIterator<PowerConduitNetwork.ReceptorEntry> receptorIterator = this.receptors.listIterator();
    private final List<PowerConduitNetwork.ReceptorEntry> storageReceptors = new ArrayList<PowerConduitNetwork.ReceptorEntry>();
    private boolean receptorsDirty = true;
    private final Map<IPowerConduit, PowerTracker> powerTrackers = new HashMap<IPowerConduit, PowerTracker>();
    private final PowerTracker networkPowerTracker = new PowerTracker();
    private final CapBankSupply capSupply = new CapBankSupply();
    private int errorSupressionA = 0;
    private int errorSupressionB = 0;

    public NetworkPowerManager(PowerConduitNetwork netowrk, World world) {
        this.network = netowrk;
        this.maxEnergyStored = 64;
    }

    public PowerTracker getTracker(IPowerConduit conduit) {
        return this.powerTrackers.get(conduit);
    }

    public PowerTracker getNetworkPowerTracker() {
        return this.networkPowerTracker;
    }

    public int getPowerInConduits() {
        return this.energyStored;
    }

    public int getMaxPowerInConduits() {
        return this.maxEnergyStored;
    }

    public long getPowerInCapacitorBanks() {
        if (this.capSupply == null) {
            return 0L;
        }
        return this.capSupply.stored;
    }

    public long getMaxPowerInCapacitorBanks() {
        if (this.capSupply == null) {
            return 0L;
        }
        return this.capSupply.maxCap;
    }

    public long getPowerInReceptors() {
        long result = 0L;
        HashSet<Object> done = new HashSet<Object>();
        for (PowerConduitNetwork.ReceptorEntry re : this.receptors) {
            IPowerInterface powerReceptor;
            if (re.emmiter.getConnectionsDirty() || done.contains((powerReceptor = re.powerInterface).getDelegate())) continue;
            done.add(powerReceptor.getDelegate());
            result += (long)powerReceptor.getEnergyStored(re.direction);
        }
        return result;
    }

    public long getMaxPowerInReceptors() {
        long result = 0L;
        HashSet<Object> done = new HashSet<Object>();
        for (PowerConduitNetwork.ReceptorEntry re : this.receptors) {
            IPowerInterface powerReceptor;
            if (re.emmiter.getConnectionsDirty() || done.contains((powerReceptor = re.powerInterface).getDelegate())) continue;
            done.add(powerReceptor.getDelegate());
            result += (long)powerReceptor.getMaxEnergyStored(re.direction);
        }
        return result;
    }

    public void applyRecievedPower() {
        block3: {
            try {
                this.doApplyRecievedPower();
            }
            catch (Exception e) {
                if (this.errorSupressionA-- <= 0) {
                    Log.warn("NetworkPowerManager: Exception thrown when updating power network " + e);
                    e.printStackTrace();
                    this.errorSupressionA = 200;
                    this.errorSupressionB = 20;
                }
                if (this.errorSupressionB-- > 0) break block3;
                Log.warn("NetworkPowerManager: Exception thrown when updating power network " + e);
                this.errorSupressionB = 20;
            }
        }
    }

    public void doApplyRecievedPower() {
        int available;
        this.trackerStartTick();
        this.checkReceptors();
        this.updateNetorkStorage();
        this.networkPowerTracker.tickStart(this.energyStored);
        this.capSupply.init();
        int numReceptors = this.receptors.size();
        int wasAvailable = available = this.energyStored + this.capSupply.canExtract;
        if (available <= 0 || this.receptors.isEmpty() && this.storageReceptors.isEmpty()) {
            this.trackerEndTick();
            this.networkPowerTracker.tickEnd(this.energyStored);
            return;
        }
        for (int appliedCount = 0; available > 0 && appliedCount < numReceptors; ++appliedCount) {
            if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
                this.receptorIterator = this.receptors.listIterator();
            }
            PowerConduitNetwork.ReceptorEntry r = this.receptorIterator.next();
            IPowerInterface pp = r.powerInterface;
            if (pp == null) continue;
            int canOffer = Math.min(r.emmiter.getMaxEnergyExtracted(r.direction), available);
            int used = pp.recieveEnergy(r.direction.getOpposite(), canOffer);
            used = Math.max(0, used);
            this.trackerSend(r.emmiter, used, false);
            if ((available -= used) <= 0) break;
        }
        int used = wasAvailable - available;
        this.energyStored -= used;
        if (!this.capSupply.capBanks.isEmpty()) {
            int capBankChange = 0;
            if (this.energyStored < 0) {
                capBankChange = this.energyStored;
                this.energyStored = 0;
            } else if (this.energyStored > 0) {
                capBankChange = Math.min(this.energyStored, this.capSupply.canFill);
                this.energyStored -= capBankChange;
            }
            if (capBankChange < 0) {
                this.capSupply.remove(Math.abs(capBankChange));
            } else if (capBankChange > 0) {
                this.capSupply.add(capBankChange);
            }
            this.capSupply.balance();
        }
        this.distributeStorageToConduits();
        this.trackerEndTick();
        this.networkPowerTracker.tickEnd(this.energyStored);
    }

    private void trackerStartTick() {
        if (!Config.detailedPowerTrackingEnabled) {
            return;
        }
        for (IPowerConduit con : this.network.getConduits()) {
            if (!con.hasExternalConnections()) continue;
            PowerTracker tracker = this.getOrCreateTracker(con);
            tracker.tickStart(con.getEnergyStored());
        }
    }

    private void trackerSend(IPowerConduit con, int sent, boolean fromBank) {
        if (!fromBank) {
            this.networkPowerTracker.powerSent(sent);
        }
        if (!Config.detailedPowerTrackingEnabled) {
            return;
        }
        this.getOrCreateTracker(con).powerSent(sent);
    }

    private void trackerRecieve(IPowerConduit con, int recieved, boolean fromBank) {
        if (!fromBank) {
            this.networkPowerTracker.powerRecieved(recieved);
        }
        if (!Config.detailedPowerTrackingEnabled) {
            return;
        }
        this.getOrCreateTracker(con).powerRecieved(recieved);
    }

    private void trackerEndTick() {
        if (!Config.detailedPowerTrackingEnabled) {
            return;
        }
        for (IPowerConduit con : this.network.getConduits()) {
            if (!con.hasExternalConnections()) continue;
            PowerTracker tracker = this.getOrCreateTracker(con);
            tracker.tickEnd(con.getEnergyStored());
        }
    }

    private PowerTracker getOrCreateTracker(IPowerConduit con) {
        PowerTracker result = this.powerTrackers.get(con);
        if (result == null) {
            result = new PowerTracker();
            this.powerTrackers.put(con, result);
        }
        return result;
    }

    private void distributeStorageToConduits() {
        if (this.maxEnergyStored <= 0 || this.energyStored <= 0) {
            for (IPowerConduit con : this.network.getConduits()) {
                con.setEnergyStored(0);
            }
            return;
        }
        this.energyStored = MathHelper.clamp_int((int)this.energyStored, (int)0, (int)this.maxEnergyStored);
        float filledRatio = (float)this.energyStored / (float)this.maxEnergyStored;
        int energyLeft = this.energyStored;
        int given = 0;
        for (IPowerConduit con : this.network.getConduits()) {
            if (energyLeft > 0) {
                int give = (int)Math.ceil((float)con.getMaxEnergyStored() * filledRatio);
                give = Math.min(give, con.getMaxEnergyStored());
                give = Math.min(give, energyLeft);
                con.setEnergyStored(give);
                given += give;
                energyLeft -= give;
                continue;
            }
            con.setEnergyStored(0);
        }
    }

    boolean isActive() {
        return this.energyStored > 0;
    }

    private void updateNetorkStorage() {
        this.maxEnergyStored = 0;
        this.energyStored = 0;
        for (IPowerConduit con : this.network.getConduits()) {
            this.maxEnergyStored += con.getMaxEnergyStored();
            con.onTick();
            this.energyStored += con.getEnergyStored();
        }
        this.energyStored = MathHelper.clamp_int((int)this.energyStored, (int)0, (int)this.maxEnergyStored);
    }

    public void receptorsChanged() {
        this.receptorsDirty = true;
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        this.storageReceptors.clear();
        for (PowerConduitNetwork.ReceptorEntry rec : this.network.getPowerReceptors()) {
            if (rec.powerInterface.getDelegate() != null && rec.powerInterface.getDelegate() instanceof IPowerStorage) {
                this.storageReceptors.add(rec);
                continue;
            }
            this.receptors.add(rec);
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    void onNetworkDestroyed() {
    }

    private int minAbs(int amount, int limit) {
        if (amount < 0) {
            return Math.max(amount, -limit);
        }
        return Math.min(amount, limit);
    }

    private static class CapBankSupplyEntry {
        final IPowerStorage capBank;
        final int canExtract;
        final int canFill;
        int toBalance;
        IPowerConduit emmiter;
        ForgeDirection direction;

        private CapBankSupplyEntry(IPowerStorage capBank, int available, int canFill, IPowerConduit emmiter, ForgeDirection direction) {
            this.capBank = capBank;
            this.canExtract = available;
            this.canFill = canFill;
            this.emmiter = emmiter;
            this.direction = direction;
        }

        void calcToBalance(double targetRatio) {
            if (this.capBank.isCreative()) {
                this.toBalance = 0;
                return;
            }
            long targetAmount = (long)Math.floor((double)this.capBank.getMaxEnergyStoredL() * targetRatio);
            long b = targetAmount - this.capBank.getEnergyStoredL();
            this.toBalance = b < 0L ? -this.canExtract : this.canFill;
        }
    }

    private class CapBankSupply {
        int canExtract;
        int canFill;
        Set<IPowerStorage> capBanks = new HashSet<IPowerStorage>();
        double filledRatio;
        long stored = 0L;
        long maxCap = 0L;
        List<CapBankSupplyEntry> enteries = new ArrayList<CapBankSupplyEntry>();

        CapBankSupply() {
        }

        void init() {
            this.capBanks.clear();
            this.enteries.clear();
            this.canExtract = 0;
            this.canFill = 0;
            this.stored = 0L;
            this.maxCap = 0L;
            double toBalance = 0.0;
            double maxToBalance = 0.0;
            for (PowerConduitNetwork.ReceptorEntry rec : NetworkPowerManager.this.storageReceptors) {
                IPowerStorage cb = (IPowerStorage)rec.powerInterface.getDelegate();
                boolean processed = this.capBanks.contains(cb.getController());
                if (!processed) {
                    this.stored += cb.getEnergyStoredL();
                    this.maxCap += cb.getMaxEnergyStoredL();
                    this.capBanks.add(cb.getController());
                }
                if (rec.emmiter.getConnectionMode(rec.direction) == ConnectionMode.IN_OUT) {
                    toBalance += (double)cb.getEnergyStoredL();
                    maxToBalance += (double)cb.getMaxEnergyStoredL();
                }
                long canGet = 0L;
                long canFill = 0L;
                if (!cb.isNetworkControlledIo(rec.direction.getOpposite())) continue;
                if (cb.isOutputEnabled(rec.direction.getOpposite())) {
                    canGet = Math.min(cb.getEnergyStoredL(), (long)cb.getMaxOutput());
                    canGet = Math.min(canGet, (long)rec.emmiter.getMaxEnergyRecieved(rec.direction));
                    this.canExtract = (int)((long)this.canExtract + canGet);
                }
                if (cb.isInputEnabled(rec.direction.getOpposite())) {
                    canFill = Math.min(cb.getMaxEnergyStoredL() - cb.getEnergyStoredL(), (long)cb.getMaxInput());
                    canFill = Math.min(canFill, (long)rec.emmiter.getMaxEnergyExtracted(rec.direction));
                    this.canFill = (int)((long)this.canFill + canFill);
                }
                this.enteries.add(new CapBankSupplyEntry(cb, (int)canGet, (int)canFill, rec.emmiter, rec.direction));
            }
            this.filledRatio = 0.0;
            if (maxToBalance > 0.0) {
                this.filledRatio = toBalance / maxToBalance;
            }
        }

        void balance() {
            if (this.enteries.size() < 2) {
                return;
            }
            this.init();
            int canRemove = 0;
            int canAdd = 0;
            for (CapBankSupplyEntry entry : this.enteries) {
                if (entry.emmiter.getConnectionMode(entry.direction) != ConnectionMode.IN_OUT) continue;
                entry.calcToBalance(this.filledRatio);
                if (entry.toBalance < 0) {
                    canRemove += -entry.toBalance;
                    continue;
                }
                canAdd += entry.toBalance;
            }
            int toalTransferAmount = Math.min(canAdd, canRemove);
            for (int i = 0; i < this.enteries.size() && toalTransferAmount > 0; ++i) {
                CapBankSupplyEntry from = this.enteries.get(i);
                if (from.emmiter.getConnectionMode(from.direction) != ConnectionMode.IN_OUT) continue;
                int amount = from.toBalance;
                amount = NetworkPowerManager.this.minAbs(amount, toalTransferAmount);
                from.capBank.addEnergy(amount);
                toalTransferAmount -= Math.abs(amount);
                int toTranfser = Math.abs(amount);
                for (int j = i + 1; j < this.enteries.size() && toTranfser > 0; ++j) {
                    CapBankSupplyEntry to = this.enteries.get(j);
                    if (Math.signum(amount) == Math.signum(to.toBalance)) continue;
                    int toAmount = Math.min(toTranfser, Math.abs(to.toBalance));
                    to.capBank.addEnergy(toAmount * (int)Math.signum(to.toBalance));
                    toTranfser -= toAmount;
                }
            }
        }

        void remove(int amount) {
            if (this.canExtract <= 0 || amount <= 0) {
                return;
            }
            double ratio = (double)amount / (double)this.canExtract;
            for (CapBankSupplyEntry entry : this.enteries) {
                long use = (int)Math.ceil(ratio * (double)entry.canExtract);
                use = Math.min(use, (long)amount);
                use = Math.min(use, (long)entry.canExtract);
                entry.capBank.addEnergy((int)(-use));
                NetworkPowerManager.this.trackerRecieve(entry.emmiter, (int)use, true);
                if ((amount = (int)((long)amount - use)) != 0) continue;
                return;
            }
        }

        void add(int amount) {
            if (this.canFill <= 0 || amount <= 0) {
                return;
            }
            double ratio = (double)amount / (double)this.canFill;
            for (CapBankSupplyEntry entry : this.enteries) {
                long add = (int)Math.ceil(ratio * (double)entry.canFill);
                add = Math.min(add, (long)entry.canFill);
                add = Math.min(add, (long)amount);
                entry.capBank.addEnergy((int)add);
                NetworkPowerManager.this.trackerSend(entry.emmiter, (int)add, true);
                if ((amount = (int)((long)amount - add)) != 0) continue;
                return;
            }
        }
    }

    private static class StarveBuffer {
        int stored;

        public StarveBuffer(int stored) {
            this.stored = stored;
        }

        void addToStore(float val) {
            this.stored = (int)((float)this.stored + val);
        }
    }
}

