/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.oc;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.oc.IOCConduit;
import crazypants.enderio.conduit.oc.OCConduitNetwork;
import crazypants.enderio.config.Config;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class OCConduit
extends AbstractConduit
implements IOCConduit {
    protected OCConduitNetwork network;
    private Map<ForgeDirection, DyeColor> signalColors = new HashMap<ForgeDirection, DyeColor>();
    public static IIcon[] coreTextures;
    public static IIcon[] longTextures;

    public OCConduit() {
    }

    public OCConduit(int meta) {
    }

    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                coreTextures = new IIcon[2];
                longTextures = new IIcon[2];
                OCConduit.coreTextures[0] = register.registerIcon(EnderIO.DOMAIN + ":ocConduitCore");
                OCConduit.coreTextures[1] = register.registerIcon(EnderIO.DOMAIN + ":ocConduitCoreAnim");
                OCConduit.longTextures[0] = register.registerIcon(EnderIO.DOMAIN + ":ocConduit");
                OCConduit.longTextures[1] = register.registerIcon(EnderIO.DOMAIN + ":ocConduitAnim");
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    @Override
    protected void readTypeSettings(ForgeDirection dir, NBTTagCompound dataRoot) {
        this.setSignalColor(dir, DyeColor.values()[dataRoot.getShort("signalColor")]);
    }

    @Override
    protected void writeTypeSettingsToNbt(ForgeDirection dir, NBTTagCompound dataRoot) {
        dataRoot.setShort("signalColor", (short)this.getSignalColor(dir).ordinal());
    }

    @Override
    public DyeColor getSignalColor(ForgeDirection dir) {
        DyeColor res = this.signalColors.get(dir);
        if (res == null) {
            return DyeColor.SILVER;
        }
        return res;
    }

    @Override
    public Collection<CollidableComponent> createCollidables(CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        if (key.dir == ForgeDirection.UNKNOWN) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.instance.createBoundsForConnectionController(key.dir, key.offset);
        CollidableComponent cc = new CollidableComponent(IOCConduit.class, bb, key.dir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        if (this.signalColors.size() >= 0) {
            byte[] modes = new byte[6];
            int i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                DyeColor col = this.signalColors.get(dir);
                modes[i] = col != null ? (int)col.ordinal() : -1;
                ++i;
            }
            nbtRoot.setByteArray("signalColors", modes);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.signalColors.clear();
        byte[] cols = nbtRoot.getByteArray("signalColors");
        if (cols != null && cols.length == 6) {
            int i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (cols[i] >= 0) {
                    this.signalColors.put(dir, DyeColor.values()[cols[i]]);
                }
                ++i;
            }
        }
    }

    @Override
    public void setSignalColor(ForgeDirection dir, DyeColor col) {
        if (this.signalColors.get(dir) == col) {
            return;
        }
        this.disconnectNode(dir);
        this.signalColors.put(dir, col);
        this.addMissingNodeConnections();
        this.setClientStateDirty();
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IOCConduit.class;
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemOCConduit, 1, 0);
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            for (ForgeDirection dir : this.getExternalConnections()) {
                this.disconnectNode(dir);
            }
        }
        this.network = (OCConduitNetwork)network;
        this.addMissingNodeConnections();
        return true;
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        int state;
        int n = state = Config.enableOCConduitsAnimatedTexture ? 1 : 0;
        if (component.dir == ForgeDirection.UNKNOWN) {
            return coreTextures[state];
        }
        return longTextures[state];
    }

    @Override
    public boolean shouldMirrorTexture() {
        return !Config.enableOCConduitsAnimatedTexture;
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    private static String prettyNode(Node o) {
        String at = "";
        Environment host = o.host();
        if (host instanceof TileEntity) {
            BlockCoord bc = new BlockCoord((TileEntity)host);
            at = " at " + bc.x + "/" + bc.y + "/" + bc.z;
        }
        return host.getClass().getName().replaceFirst("^.*\\.", "") + at;
    }

    private static EnumChatFormatting dye2chat(DyeColor dyeColor) {
        switch (dyeColor) {
            case BLACK: {
                return EnumChatFormatting.BLACK;
            }
            case BLUE: {
                return EnumChatFormatting.DARK_BLUE;
            }
            case BROWN: {
                return EnumChatFormatting.DARK_RED;
            }
            case CYAN: {
                return EnumChatFormatting.DARK_AQUA;
            }
            case GRAY: {
                return EnumChatFormatting.DARK_GRAY;
            }
            case GREEN: {
                return EnumChatFormatting.DARK_GREEN;
            }
            case LIGHT_BLUE: {
                return EnumChatFormatting.BLUE;
            }
            case LIME: {
                return EnumChatFormatting.GREEN;
            }
            case MAGENTA: {
                return EnumChatFormatting.LIGHT_PURPLE;
            }
            case ORANGE: {
                return EnumChatFormatting.GOLD;
            }
            case PINK: {
                return EnumChatFormatting.LIGHT_PURPLE;
            }
            case PURPLE: {
                return EnumChatFormatting.DARK_PURPLE;
            }
            case RED: {
                return EnumChatFormatting.RED;
            }
            case SILVER: {
                return EnumChatFormatting.GRAY;
            }
            case WHITE: {
                return EnumChatFormatting.WHITE;
            }
            case YELLOW: {
                return EnumChatFormatting.YELLOW;
            }
        }
        return null;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        DyeColor col = DyeColor.getColorFromDye((ItemStack)player.getCurrentEquippedItem());
        if (col != null && res.component != null) {
            this.setSignalColor(res.component.dir, col);
            return true;
        }
        if (ConduitUtil.isProbeEquipped(player)) {
            if (!player.worldObj.isRemote) {
                BlockCoord bc = this.getLocation();
                if (this.network != null) {
                    boolean noconnections = true;
                    for (DyeColor color : DyeColor.values()) {
                        if (!this.node(color).neighbors().iterator().hasNext()) continue;
                        noconnections = false;
                        ChatComponentText coltxt = new ChatComponentText(color.getLocalisedName());
                        coltxt.getChatStyle().setColor(OCConduit.dye2chat(color));
                        ChatComponentText chantxt = new ChatComponentText("Channel ");
                        chantxt.appendSibling((IChatComponent)coltxt);
                        chantxt.appendText(" at " + bc.x + "/" + bc.y + "/" + bc.z);
                        player.addChatMessage((IChatComponent)chantxt);
                        for (Node other : this.node(color).neighbors()) {
                            player.addChatMessage((IChatComponent)new ChatComponentText("  Connected to: " + OCConduit.prettyNode(other)));
                        }
                    }
                    if (noconnections) {
                        player.addChatMessage((IChatComponent)new ChatComponentText("No connections at " + bc.x + "/" + bc.y + "/" + bc.z));
                    }
                } else {
                    player.addChatMessage((IChatComponent)new ChatComponentText("No network at " + bc.x + "/" + bc.y + "/" + bc.z));
                }
            }
            return true;
        }
        if (ToolUtil.isToolEquipped(player) && !this.getBundle().getEntity().getWorldObj().isRemote && res != null && res.component != null) {
            ForgeDirection connDir = res.component.dir;
            ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.sideHit);
            if (all != null && this.containsExternalConnection(connDir)) {
                for (RaytraceResult rtr : all) {
                    if (rtr == null || rtr.component == null || !"ColorController".equals(rtr.component.data)) continue;
                    this.setSignalColor(connDir, DyeColor.getNext((DyeColor)this.getSignalColor(connDir)));
                    return true;
                }
            }
            if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                return ConduitUtil.joinConduits(this, faceHit);
            }
            if (this.externalConnections.contains(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                return true;
            }
            if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconectConduits(this, connDir);
                this.addMissingNodeConnections();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        if (mode == ConnectionMode.DISABLED) {
            this.disconnectNode(dir);
        }
        super.setConnectionMode(dir, mode);
    }

    @Override
    public void connectionsChanged() {
        super.connectionsChanged();
        this.addMissingNodeConnections();
    }

    private void addMissingNodeConnections() {
        BlockCoord loc = this.getLocation();
        if (loc != null && this.network != null) {
            World world = this.getBundle().getWorld();
            EnumSet<ForgeDirection> conns = this.getConnections();
            for (DyeColor color : DyeColor.values()) {
                HashSet<Node> should = new HashSet<Node>();
                for (ForgeDirection direction : conns) {
                    if (this.getSignalColor(direction) != color) continue;
                    TileEntity te = this.getLocation().getLocation(direction).getTileEntity((IBlockAccess)world);
                    Node other = null;
                    if (te instanceof SidedEnvironment) {
                        other = ((SidedEnvironment)te).sidedNode(direction.getOpposite());
                    } else if (te instanceof Environment) {
                        other = ((Environment)te).node();
                    }
                    if (other == null || other == this.node(color)) continue;
                    should.add(other);
                }
                for (Node other : should) {
                    if (this.node(color).isNeighborOf(other)) continue;
                    this.node(color).connect(other);
                }
            }
        }
    }

    private void disconnectNode(ForgeDirection direction) {
        World world = this.getBundle().getWorld();
        TileEntity te = this.getLocation().getLocation(direction).getTileEntity((IBlockAccess)world);
        Node other = null;
        if (te instanceof SidedEnvironment) {
            other = ((SidedEnvironment)te).sidedNode(direction.getOpposite());
        } else if (te instanceof Environment) {
            other = ((Environment)te).node();
        }
        if (other != null) {
            this.disconnectNode(other, this.getSignalColor(direction));
        }
    }

    private void disconnectNode(Node other, DyeColor color) {
        if (other == this.node(color)) {
            return;
        }
        Environment otherHost = other.host();
        if (otherHost instanceof OCConduitNetwork && otherHost != this.network) {
            this.node(color).disconnect(other);
            return;
        }
        World world = this.getBundle().getWorld();
        EnumSet<ForgeDirection> conns = this.getConnections();
        ArrayList<Object> toCheck = new ArrayList<Object>();
        if (otherHost instanceof TileEntity) {
            TileEntity otherTe = (TileEntity)otherHost;
            toCheck.add(otherTe);
        } else {
            for (ForgeDirection direction : conns) {
                if (this.getSignalColor(direction) != color) continue;
                TileEntity tileEntity = this.getLocation().getLocation(direction).getTileEntity((IBlockAccess)world);
                Node other2 = null;
                if (tileEntity instanceof SidedEnvironment) {
                    other2 = ((SidedEnvironment)tileEntity).sidedNode(direction.getOpposite());
                } else if (tileEntity instanceof Environment) {
                    other2 = ((Environment)tileEntity).node();
                }
                if (other2 != other) continue;
                toCheck.add(tileEntity);
            }
        }
        boolean stayConnected = false;
        for (TileEntity tileEntity : toCheck) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                BlockCoord otherPos;
                BlockCoord connTo;
                if (stayConnected) continue;
                boolean checkThisSide = true;
                if (otherHost instanceof SidedEnvironment) {
                    boolean bl = checkThisSide = ((SidedEnvironment)otherHost).sidedNode(direction) != null;
                }
                if (!checkThisSide || (connTo = (otherPos = new BlockCoord(tileEntity)).getLocation(direction)).equals((Object)this.getLocation())) continue;
                TileEntity connToTe = connTo.getTileEntity((IBlockAccess)world);
                if (connToTe instanceof SidedEnvironment) {
                    stayConnected = ((SidedEnvironment)connToTe).sidedNode(direction.getOpposite()) == this.node(color);
                    continue;
                }
                if (!(connToTe instanceof Environment)) continue;
                stayConnected = ((Environment)connToTe).node() == this.node(color);
            }
        }
        if (!stayConnected) {
            this.node(color).disconnect(other);
        }
    }

    public EnumSet<ForgeDirection> getConnections() {
        EnumSet<ForgeDirection> cons = EnumSet.noneOf(ForgeDirection.class);
        cons.addAll(this.getConduitConnections());
        for (ForgeDirection dir : this.getExternalConnections()) {
            if (this.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
            cons.add(dir);
        }
        return cons;
    }

    @Override
    public ConnectionMode getNextConnectionMode(ForgeDirection dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        mode = mode == ConnectionMode.IN_OUT ? ConnectionMode.DISABLED : ConnectionMode.IN_OUT;
        return mode;
    }

    @Override
    public ConnectionMode getPreviousConnectionMode(ForgeDirection dir) {
        return this.getNextConnectionMode(dir);
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction, boolean ignoreConnectionMode) {
        TileEntity te = this.getLocation().getLocation(direction).getTileEntity((IBlockAccess)this.getBundle().getWorld());
        if (te instanceof SidedEnvironment) {
            if (this.getBundle().getWorld().isRemote) {
                return ((SidedEnvironment)te).canConnect(direction.getOpposite());
            }
            return ((SidedEnvironment)te).sidedNode(direction.getOpposite()) != null;
        }
        return te instanceof Environment;
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public Node node() {
        return this.network != null ? this.network.node(DyeColor.SILVER) : null;
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public Node node(DyeColor subnet) {
        return this.network != null ? this.network.node(subnet) : null;
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public Node sidedNode(ForgeDirection side) {
        return this.getConnections().contains(side) ? this.node(this.getSignalColor(side)) : null;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="OpenComputersAPI|Network")
    public boolean canConnect(ForgeDirection side) {
        return this.getConnections().contains(side);
    }

    @Override
    public void invalidate() {
    }
}

