/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector2f;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.LiquidConduit;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class LiquidConduitRenderer
extends DefaultConduitRenderer
implements IResourceManagerReloadListener {
    private float downRatio;
    private float flatRatio;
    private float upRatio;
    private static Map<CollidableComponent, Map<Fluid, List<CachableRenderStatement>>> cache = new WeakHashMap<CollidableComponent, Map<Fluid, List<CachableRenderStatement>>>();

    private LiquidConduitRenderer() {
    }

    public static LiquidConduitRenderer create() {
        LiquidConduitRenderer result = new LiquidConduitRenderer();
        RenderUtil.registerReloadListener((IResourceManagerReloadListener)result);
        return result;
    }

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit instanceof LiquidConduit;
    }

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight, RenderBlocks rb) {
        this.calculateRatios((LiquidConduit)conduit);
        super.renderEntity(conduitBundleRenderer, te, conduit, x, y, z, partialTick, worldLight, rb);
    }

    @Override
    protected void renderConduit(IIcon tex, IConduit conduit, CollidableComponent component, float brightness) {
        if (this.isNSEWUD(component.dir)) {
            BoundingBox[] cubes;
            LiquidConduit lc = (LiquidConduit)conduit;
            FluidStack fluid = lc.getFluidType();
            if (fluid != null) {
                LiquidConduitRenderer.renderFluidOutline(component, fluid);
            }
            for (BoundingBox cube : cubes = this.toCubes(component.bound)) {
                this.drawSection(cube, tex.getMinU(), tex.getMaxU(), tex.getMinV(), tex.getMaxV(), component.dir, false);
            }
        } else {
            this.drawSection(component.bound, tex.getMinU(), tex.getMaxU(), tex.getMinV(), tex.getMaxV(), component.dir, true);
        }
        if (conduit.getConnectionMode(component.dir) == ConnectionMode.DISABLED) {
            tex = EnderIO.blockConduitBundle.getConnectorIcon(component.data);
            List corners = component.bound.getCornersWithUvForFace(component.dir, tex.getMinU(), tex.getMaxU(), tex.getMinV(), tex.getMaxV());
            for (Vertex c : corners) {
                CubeRenderer.addVecWithUV((Vector3d)c.xyz, (double)c.uv.x, (double)c.uv.y);
            }
            for (int i = corners.size() - 1; i >= 0; --i) {
                Vertex c;
                c = (Vertex)corners.get(i);
                CubeRenderer.addVecWithUV((Vector3d)c.xyz, (double)c.uv.x, (double)c.uv.y);
            }
        }
    }

    public static void renderFluidOutline(CollidableComponent component, FluidStack fluid) {
        LiquidConduitRenderer.renderFluidOutline(component, fluid, 1.0, 0.8125f);
    }

    public static void renderFluidOutline(CollidableComponent component, FluidStack fluid, double scaleFactor, float outlineWidth) {
        for (CachableRenderStatement elem : LiquidConduitRenderer.computeFluidOutlineToCache(component, fluid.getFluid(), scaleFactor, outlineWidth)) {
            elem.execute();
        }
    }

    public static List<CachableRenderStatement> computeFluidOutlineToCache(CollidableComponent component, Fluid fluid, double scaleFactor, float outlineWidth) {
        BoundingBox bbb;
        List<CachableRenderStatement> data;
        Map<Fluid, List<CachableRenderStatement>> cache0 = cache.get(component);
        if (cache0 == null) {
            cache0 = new HashMap<Fluid, List<CachableRenderStatement>>();
            cache.put(component, cache0);
        }
        if ((data = cache0.get(fluid)) != null) {
            return data;
        }
        data = new ArrayList<CachableRenderStatement>();
        cache0.put(fluid, data);
        IIcon texture = fluid.getStillIcon();
        if (texture == null && (texture = fluid.getIcon()) == null) {
            return data;
        }
        if (scaleFactor == 1.0) {
            bbb = component.bound;
        } else {
            double xScale = Math.abs(component.dir.offsetX) == 1 ? 1.0 : scaleFactor;
            double yScale = Math.abs(component.dir.offsetY) == 1 ? 1.0 : scaleFactor;
            double zScale = Math.abs(component.dir.offsetZ) == 1 ? 1.0 : scaleFactor;
            bbb = component.bound.scale(xScale, yScale, zScale);
        }
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            if (face == component.dir || face == component.dir.getOpposite()) continue;
            data.add(new CachableRenderStatement.SetNormal(face.offsetX, face.offsetY, face.offsetZ));
            Vector3d offset = ForgeDirectionOffsets.offsetScaled((ForgeDirection)face, (double)-0.005);
            Vector2f uv = new Vector2f();
            List edges = RenderUtil.getEdgesForFace((ForgeDirection)face);
            for (ForgeDirection edge : edges) {
                if (edge == component.dir || edge == component.dir.getOpposite()) continue;
                float xLen = 1.0f - (float)Math.abs(edge.offsetX) * outlineWidth;
                float yLen = 1.0f - (float)Math.abs(edge.offsetY) * outlineWidth;
                float zLen = 1.0f - (float)Math.abs(edge.offsetZ) * outlineWidth;
                BoundingBox bb = bbb.scale(xLen, yLen, zLen);
                List corners = bb.getCornersForFace(face);
                for (Vector3f unitCorn : corners) {
                    Vector3d corner = new Vector3d(unitCorn);
                    corner.add(offset);
                    corner.x += (double)((float)((double)edge.offsetX * 0.5 * (double)bbb.sizeX()) - Math.signum(edge.offsetX) * xLen / 2.0f * bbb.sizeX() * 2.0f);
                    corner.y += (double)((float)((double)edge.offsetY * 0.5 * (double)bbb.sizeY()) - Math.signum(edge.offsetY) * yLen / 2.0f * bbb.sizeY() * 2.0f);
                    corner.z += (double)((float)((double)edge.offsetZ * 0.5 * (double)bbb.sizeZ()) - Math.signum(edge.offsetZ) * zLen / 2.0f * bbb.sizeZ() * 2.0f);
                    RenderUtil.getUvForCorner((Vector2f)uv, (Vector3d)corner, (int)0, (int)0, (int)0, (ForgeDirection)face, (IIcon)texture);
                    data.add(new CachableRenderStatement.AddVertexWithUV(corner.x, corner.y, corner.z, uv.x, uv.y));
                }
            }
        }
        return data;
    }

    @Override
    protected void renderTransmission(IConduit con, IIcon tex, CollidableComponent component, float brightness) {
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void renderDynamicEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight) {
        if (((LiquidConduit)conduit).getTank().getFilledRatio() <= 0.0f) {
            return;
        }
        Collection<CollidableComponent> components = conduit.getCollidableComponents();
        Tessellator tessellator = Tessellator.instance;
        this.calculateRatios((LiquidConduit)conduit);
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        for (CollidableComponent component : components) {
            BoundingBox[] cubes;
            if (!this.renderComponent(component) || !this.isNSEWUD(component.dir) || conduit.getTransmitionTextureForState(component) == null) continue;
            tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            IIcon tex = conduit.getTransmitionTextureForState(component);
            for (BoundingBox cube : cubes = this.toCubes(component.bound)) {
                this.drawSection(cube, tex.getMinU(), tex.getMaxU(), tex.getMinV(), tex.getMaxV(), component.dir, true);
            }
        }
    }

    @Override
    protected void setVerticesForTransmission(BoundingBox bound, ForgeDirection id) {
        float yScale = this.getRatioForConnection(id);
        float xs = id.offsetX == 0 ? 0.9f : 1.0f;
        float ys = id.offsetY == 0 ? Math.min(yScale, 0.9f) : yScale;
        float zs = id.offsetZ == 0 ? 0.9f : 1.0f;
        float sizeY = bound.sizeY();
        bound = bound.scale(xs, ys, zs);
        float transY = (bound.sizeY() - sizeY) / 2.0f;
        Vector3d translation = new Vector3d(0.0, (double)transY, 0.0);
        CubeRenderer.setupVertices((BoundingBox)bound.translate(translation));
    }

    private void calculateRatios(LiquidConduit conduit) {
        ConduitTank tank = conduit.getTank();
        int totalAmount = tank.getFluidAmount();
        int upCapacity = 0;
        if (conduit.containsConduitConnection(ForgeDirection.UP) || conduit.containsExternalConnection(ForgeDirection.UP)) {
            upCapacity = 250;
        }
        int downCapacity = 0;
        if (conduit.containsConduitConnection(ForgeDirection.DOWN) || conduit.containsExternalConnection(ForgeDirection.DOWN)) {
            downCapacity = 250;
        }
        int flatCapacity = tank.getCapacity() - upCapacity - downCapacity;
        int usedCapacity = 0;
        if (downCapacity > 0) {
            int inDown = Math.min(totalAmount, downCapacity);
            usedCapacity += inDown;
            this.downRatio = (float)inDown / (float)downCapacity;
        }
        if (flatCapacity > 0 && usedCapacity < totalAmount) {
            int inFlat = Math.min(flatCapacity, totalAmount - usedCapacity);
            usedCapacity += inFlat;
            this.flatRatio = (float)inFlat / (float)flatCapacity;
        } else {
            this.flatRatio = 0.0f;
        }
        if (upCapacity > 0 && usedCapacity < totalAmount) {
            int inUp = Math.min(upCapacity, totalAmount - usedCapacity);
            this.upRatio = (float)inUp / (float)upCapacity;
        } else {
            this.upRatio = 0.0f;
        }
    }

    private float getRatioForConnection(ForgeDirection id) {
        if (id == ForgeDirection.UP) {
            return this.upRatio;
        }
        if (id == ForgeDirection.DOWN) {
            return this.downRatio;
        }
        return this.flatRatio;
    }

    public void onResourceManagerReload(IResourceManager p_110549_1_) {
        cache.clear();
    }

    private static interface CachableRenderStatement {
        public void execute();

        public static class AddVertexWithUV
        implements CachableRenderStatement {
            private final double x;
            private final double y;
            private final double z;
            private final double u;
            private final double v;

            private AddVertexWithUV(double x, double y, double z, double u, double v) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.u = u;
                this.v = v;
            }

            @Override
            public void execute() {
                Tessellator.instance.addVertexWithUV(this.x, this.y, this.z, this.u, this.v);
            }
        }

        public static class SetNormal
        implements CachableRenderStatement {
            private final float x;
            private final float y;
            private final float z;

            private SetNormal(float x, float y, float z) {
                this.x = x;
                this.y = y;
                this.z = z;
            }

            @Override
            public void execute() {
                Tessellator.instance.setNormal(this.x, this.y, this.z);
            }
        }
    }
}

