/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduit.liquid.EnderLiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.tool.ToolUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class EnderLiquidConduit
extends AbstractLiquidConduit {
    public static final String ICON_KEY = "enderio:liquidConduitEnder";
    public static final String ICON_CORE_KEY = "enderio:liquidConduitCoreEnder";
    public static final String ICON_EXTRACT_KEY = "enderio:liquidConduitAdvancedInput";
    public static final String ICON_INSERT_KEY = "enderio:liquidConduitAdvancedOutput";
    public static final String ICON_IN_OUT_KEY = "enderio:liquidConduitAdvancedInOut";
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private EnderLiquidConduitNetwork network;
    private int ticksSinceFailedExtract;
    private final EnumMap<ForgeDirection, FluidFilter> outputFilters = new EnumMap(ForgeDirection.class);
    private final EnumMap<ForgeDirection, FluidFilter> inputFilters = new EnumMap(ForgeDirection.class);

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                ICONS.put(EnderLiquidConduit.ICON_KEY, register.registerIcon(EnderLiquidConduit.ICON_KEY));
                ICONS.put(EnderLiquidConduit.ICON_CORE_KEY, register.registerIcon(EnderLiquidConduit.ICON_CORE_KEY));
                ICONS.put(EnderLiquidConduit.ICON_EXTRACT_KEY, register.registerIcon(EnderLiquidConduit.ICON_EXTRACT_KEY));
                ICONS.put(EnderLiquidConduit.ICON_INSERT_KEY, register.registerIcon(EnderLiquidConduit.ICON_INSERT_KEY));
                ICONS.put(EnderLiquidConduit.ICON_IN_OUT_KEY, register.registerIcon(EnderLiquidConduit.ICON_IN_OUT_KEY));
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemLiquidConduit, 1, 2);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        if (player.getCurrentEquippedItem() == null) {
            return false;
        }
        if (ToolUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().getWorldObj().isRemote && res != null && res.component != null) {
                ForgeDirection connDir = res.component.dir;
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.sideHit);
                if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockCoord loc = this.getLocation().getLocation(faceHit);
                    ILiquidConduit n = ConduitUtil.getConduit(this.getBundle().getEntity().getWorldObj(), loc.x, loc.y, loc.z, ILiquidConduit.class);
                    if (n == null) {
                        return false;
                    }
                    if (!(n instanceof EnderLiquidConduit)) {
                        return false;
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    public FluidFilter getFilter(ForgeDirection dir, boolean isInput) {
        if (isInput) {
            return this.inputFilters.get(dir);
        }
        return this.outputFilters.get(dir);
    }

    public void setFilter(ForgeDirection dir, FluidFilter filter, boolean isInput) {
        if (isInput) {
            this.inputFilters.put(dir, filter);
        } else {
            this.outputFilters.put(dir, filter);
        }
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        if (!(network instanceof EnderLiquidConduitNetwork)) {
            return false;
        }
        this.network = (EnderLiquidConduitNetwork)network;
        for (ForgeDirection dir : this.externalConnections) {
            this.network.connectionChanged(this, dir);
        }
        return true;
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return ICONS.get(ICON_CORE_KEY);
        }
        return ICONS.get(ICON_KEY);
    }

    public IIcon getTextureForInputMode() {
        return ICONS.get(ICON_EXTRACT_KEY);
    }

    public IIcon getTextureForOutputMode() {
        return ICONS.get(ICON_INSERT_KEY);
    }

    public IIcon getTextureForInOutMode() {
        return ICONS.get(ICON_IN_OUT_KEY);
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        return con instanceof EnderLiquidConduit;
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshConnections(dir);
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, ForgeDirection dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshConnections(dir);
    }

    private void refreshConnections(ForgeDirection dir) {
        if (this.network == null) {
            return;
        }
        this.network.connectionChanged(this, dir);
    }

    @Override
    public void externalConnectionAdded(ForgeDirection fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (world.isRemote) {
            return;
        }
        this.doExtract();
    }

    private void doExtract() {
        BlockCoord loc = this.getLocation();
        if (!this.hasExtractableMode()) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25 && this.ticksSinceFailedExtract % 10 != 0) {
            return;
        }
        for (ForgeDirection dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir)) continue;
            this.ticksSinceFailedExtract = 0;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.network == null || !this.getConnectionMode(from).acceptsInput()) {
            return 0;
        }
        return this.network.fillFrom(this, from, resource, doFill);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.network == null) {
            return false;
        }
        return this.getConnectionMode(from).acceptsInput();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.network == null) {
            return new FluidTankInfo[0];
        }
        return this.network.getTankInfo(this, from);
    }

    @Override
    protected void readTypeSettings(ForgeDirection dir, NBTTagCompound dataRoot) {
        super.readTypeSettings(dir, dataRoot);
        if (dataRoot.hasKey("outputFilters")) {
            FluidFilter out = new FluidFilter();
            out.readFromNBT(dataRoot.getCompoundTag("outputFilters"));
            this.outputFilters.put(dir, out);
        }
        if (dataRoot.hasKey("inputFilters")) {
            FluidFilter in = new FluidFilter();
            in.readFromNBT(dataRoot.getCompoundTag("inputFilters"));
            this.inputFilters.put(dir, in);
        }
    }

    @Override
    protected void writeTypeSettingsToNbt(ForgeDirection dir, NBTTagCompound dataRoot) {
        FluidFilter in;
        super.writeTypeSettingsToNbt(dir, dataRoot);
        FluidFilter out = this.outputFilters.get(dir);
        if (out != null) {
            NBTTagCompound outTag = new NBTTagCompound();
            out.writeToNBT(outTag);
            dataRoot.setTag("outputFilters", (NBTBase)outTag);
        }
        if ((in = this.inputFilters.get(dir)) != null) {
            NBTTagCompound inTag = new NBTTagCompound();
            in.writeToNBT(inTag);
            dataRoot.setTag("inputFilters", (NBTBase)inTag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        FluidFilter f;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<ForgeDirection, FluidFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || (f = entry.getValue()) == null || f.isDefault()) continue;
            itemRoot = new NBTTagCompound();
            f.writeToNBT(itemRoot);
            nbtRoot.setTag("inFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<ForgeDirection, FluidFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || (f = entry.getValue()) == null || f.isDefault()) continue;
            itemRoot = new NBTTagCompound();
            f.writeToNBT(itemRoot);
            nbtRoot.setTag("outFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            FluidFilter f;
            NBTTagCompound filterTag;
            String key = "inFilts." + dir.name();
            if (nbtRoot.hasKey(key)) {
                filterTag = (NBTTagCompound)nbtRoot.getTag(key);
                f = new FluidFilter();
                f.readFromNBT(filterTag);
                if (!f.isEmpty()) {
                    this.inputFilters.put(dir, f);
                }
            }
            if (!nbtRoot.hasKey(key = "outFilts." + dir.name())) continue;
            filterTag = (NBTTagCompound)nbtRoot.getTag(key);
            f = new FluidFilter();
            f.readFromNBT(filterTag);
            if (f.isEmpty()) continue;
            this.outputFilters.put(dir, f);
        }
    }
}

