/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ChatUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.tool.ToolUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractTankConduit
extends AbstractLiquidConduit {
    protected ConduitTank tank = new ConduitTank(0);
    protected boolean stateDirty = false;
    protected long lastEmptyTick = 0L;
    protected int numEmptyEvents = 0;
    protected boolean fluidTypeLocked = false;
    private int lastLightValue;

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        if (player.getCurrentEquippedItem() == null) {
            return false;
        }
        AbstractTankConduitNetwork<? extends AbstractTankConduit> network = this.getTankNetwork();
        if (ToolUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().getWorldObj().isRemote && res != null && res.component != null) {
                ForgeDirection connDir = res.component.dir;
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.sideHit);
                if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockCoord loc = this.getLocation().getLocation(faceHit);
                    ILiquidConduit n = ConduitUtil.getConduit(this.getBundle().getEntity().getWorldObj(), loc.x, loc.y, loc.z, ILiquidConduit.class);
                    if (n == null) {
                        return false;
                    }
                    if (!this.canJoinNeighbour(n)) {
                        return false;
                    }
                    if (!(n instanceof AbstractTankConduit)) {
                        return false;
                    }
                    AbstractTankConduit neighbour = (AbstractTankConduit)n;
                    if (neighbour.getFluidType() == null || this.getFluidType() == null) {
                        FluidStack type = this.getFluidType();
                        type = type != null ? type : neighbour.getFluidType();
                        neighbour.setFluidTypeOnNetwork(neighbour, type);
                        this.setFluidTypeOnNetwork(this, type);
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    FluidStack curFluidType = null;
                    if (this.getTankNetwork() != null) {
                        curFluidType = this.getTankNetwork().getFluidType();
                    }
                    ConduitUtil.disconectConduits(this, connDir);
                    this.setFluidType(curFluidType);
                }
            }
            return true;
        }
        if (player.getCurrentEquippedItem().getItem() == Items.bucket) {
            if (!this.getBundle().getEntity().getWorldObj().isRemote) {
                long curTick = this.getBundle().getEntity().getWorldObj().getTotalWorldTime();
                this.numEmptyEvents = curTick - this.lastEmptyTick < 20L ? ++this.numEmptyEvents : 1;
                this.lastEmptyTick = curTick;
                if (this.numEmptyEvents < 2) {
                    if (network.fluidTypeLocked) {
                        network.setFluidTypeLocked(false);
                        this.numEmptyEvents = 0;
                        ChatUtil.sendNoSpamUnloc((EntityPlayer)player, (Lang)EnderIO.lang, (String[])new String[]{"itemLiquidConduit.unlockedType"});
                    }
                } else if (network != null) {
                    network.setFluidType(null);
                    this.numEmptyEvents = 0;
                }
            }
            return true;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.getCurrentEquippedItem());
        if (fluid != null) {
            if (!this.getBundle().getEntity().getWorldObj().isRemote && network != null && (network.getFluidType() == null || network.getTotalVolume() < 500 || LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), fluid))) {
                network.setFluidType(fluid);
                network.setFluidTypeLocked(true);
                ChatUtil.sendNoSpamUnloc((EntityPlayer)player, (Lang)EnderIO.lang, (String[])new String[]{"itemLiquidConduit.lockedType", " " + FluidRegistry.getFluidName((FluidStack)fluid)});
            }
            return true;
        }
        return false;
    }

    void setFluidTypeLocked(boolean fluidTypeLocked) {
        if (fluidTypeLocked == this.fluidTypeLocked) {
            return;
        }
        this.fluidTypeLocked = fluidTypeLocked;
        this.stateDirty = true;
    }

    private void setFluidTypeOnNetwork(AbstractTankConduit con, FluidStack type) {
        AbstractConduitNetwork<?, ?> n = con.getNetwork();
        if (n != null) {
            AbstractTankConduitNetwork network = (AbstractTankConduitNetwork)n;
            network.setFluidType(type);
        }
    }

    protected abstract boolean canJoinNeighbour(ILiquidConduit var1);

    public abstract AbstractTankConduitNetwork<? extends AbstractTankConduit> getTankNetwork();

    public void setFluidType(FluidStack liquidType) {
        if (this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(liquidType)) {
            return;
        }
        if (liquidType != null) {
            liquidType = liquidType.copy();
        } else if (this.tank.getFluid() == null) {
            return;
        }
        this.tank.setLiquid(liquidType);
        this.stateDirty = true;
    }

    public ConduitTank getTank() {
        return this.tank;
    }

    public FluidStack getFluidType() {
        FluidStack result = null;
        if (this.getTankNetwork() != null) {
            result = this.getTankNetwork().getFluidType();
        }
        if (result == null) {
            result = this.tank.getFluid();
        }
        return result;
    }

    public boolean isFluidTypeLocked() {
        return this.fluidTypeLocked;
    }

    @Override
    public void updateEntity(World world) {
        int lightValue = this.getLightValue();
        if (this.lastLightValue != lightValue) {
            BlockCoord bc = this.getLocation();
            this.getBundle().getWorld().updateLightByType(EnumSkyBlock.Block, bc.x, bc.y, bc.z);
            this.lastLightValue = lightValue;
        }
        super.updateEntity(world);
    }

    @Override
    public int getLightValue() {
        FluidStack stack = this.getFluidType();
        return stack == null || stack.amount <= 0 ? 0 : stack.getFluid().getLuminosity(stack);
    }

    protected abstract void updateTank();

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.updateTank();
        if (nbtRoot.hasKey("tank")) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtRoot.getCompoundTag("tank"));
            this.tank.setLiquid(liquid);
        } else {
            this.tank.setLiquid(null);
        }
        this.fluidTypeLocked = nbtRoot.getBoolean("fluidLocked");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        FluidStack ft = this.getFluidType();
        if (ConduitUtil.isFluidValid(ft)) {
            this.updateTank();
            ft = ft.copy();
            ft.amount = this.tank.getFluidAmount();
            nbtRoot.setTag("tank", (NBTBase)ft.writeToNBT(new NBTTagCompound()));
        }
        nbtRoot.setBoolean("fluidLocked", this.fluidTypeLocked);
    }
}

