/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.PowerItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PowerItemFilter
implements IItemFilter {
    public static final int MAX_LEVEL = 4;
    CmpMode mode = CmpMode.EQUAL;
    boolean sticky;
    int level = 4;

    @Override
    public boolean doesItemPassFilter(NetworkedInventory inv, ItemStack item) {
        if (item != null && item.getItem() instanceof IEnergyContainerItem) {
            IEnergyContainerItem chargable = (IEnergyContainerItem)item.getItem();
            int max = chargable.getMaxEnergyStored(item);
            int cur = chargable.getEnergyStored(item);
            int ref = (int)((long)max * (long)this.level / 4L);
            switch (this.mode) {
                case LESS: {
                    return cur < ref;
                }
                case LESS_EQUAL: {
                    return cur <= ref;
                }
                case EQUAL: {
                    return cur == ref;
                }
                case MORE_EQUAL: {
                    return cur >= ref;
                }
                case MORE: {
                    return cur > ref;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        boolean res = this.sticky && this.doesItemPassFilter(inv, item);
        return res;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    public void createGhostSlots(List<GhostSlot> slots, int xOffset, int yOffset, Runnable cb) {
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    public CmpMode getMode() {
        return this.mode;
    }

    public void setMode(CmpMode mode) {
        this.mode = mode;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemFilterGui getGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        return new PowerItemFilterGui(gui, itemConduit, isInput);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        this.readSettingsFromNBT(nbtRoot);
    }

    protected void readSettingsFromNBT(NBTTagCompound nbtRoot) {
        this.mode = CmpMode.values()[nbtRoot.getByte("mode") & 0xFF];
        this.level = nbtRoot.getShort("level");
        this.sticky = nbtRoot.getBoolean("sticky");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        this.writeSettingToNBT(nbtRoot);
    }

    protected void writeSettingToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.setByte("mode", (byte)this.mode.ordinal());
        nbtRoot.setShort("level", (short)this.level);
        nbtRoot.setBoolean("sticky", this.sticky);
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        this.writeSettingToNBT(settingsTag);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)settingsTag, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(ByteBuf buf) {
        NBTTagCompound settingsTag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readSettingsFromNBT(settingsTag);
    }

    public static enum CmpMode {
        LESS,
        LESS_EQUAL,
        EQUAL,
        MORE_EQUAL,
        MORE;


        public CmpMode next() {
            CmpMode[] values = CmpMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

