/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.Lang;
import com.enderio.core.common.util.ChatUtil;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.ExistingItemFilter;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.IItemFilterUpgrade;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemExistingItemFilter
extends Item
implements IItemFilterUpgrade,
IResourceTooltipProvider {
    public static ItemExistingItemFilter create() {
        ItemExistingItemFilter result = new ItemExistingItemFilter();
        result.init();
        return result;
    }

    protected ItemExistingItemFilter() {
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemExistingItemFilter.unlocalisedName);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setMaxStackSize(64);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemExistingItemFilter.unlocalisedName);
    }

    @Override
    public IItemFilter createFilterFromStack(ItemStack stack) {
        ExistingItemFilter filter = new ExistingItemFilter();
        if (stack.stackTagCompound != null && stack.stackTagCompound.hasKey("filter")) {
            filter.readFromNBT(stack.stackTagCompound.getCompoundTag("filter"));
        }
        return filter;
    }

    public boolean onItemUse(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        TileEntity te;
        if (world.isRemote) {
            return true;
        }
        if (player.isSneaking() && (te = world.getTileEntity(x, y, z)) instanceof IInventory) {
            IInventory inv = ItemUtil.getInventory((IInventory)((IInventory)te));
            ExistingItemFilter filter = (ExistingItemFilter)this.createFilterFromStack(item);
            String unloc = "item.itemExistingItemFilter." + (filter.mergeSnapshot(inv) ? "filterUpdated" : "filterNotUpdated");
            ChatUtil.sendNoSpamUnloc((EntityPlayer)player, (Lang)EnderIO.lang, (String[])new String[]{unloc});
            FilterRegister.writeFilterToStack(filter, item);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister IIconRegister2) {
        this.itemIcon = IIconRegister2.registerIcon("enderio:existingItemFilter");
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.getUnlocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (FilterRegister.isFilterSet(par1ItemStack) && SpecialTooltipHandler.showAdvancedTooltips()) {
            par3List.add(EnumChatFormatting.ITALIC + EnderIO.lang.localize("itemConduitFilterUpgrade.configured"));
            par3List.add(EnumChatFormatting.ITALIC + EnderIO.lang.localize("itemConduitFilterUpgrade.clearConfigMethod"));
        }
    }
}

