/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.IItemFilterUpgrade;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;

public class ItemBasicItemFilter
extends Item
implements IItemFilterUpgrade {
    private final IIcon[] icons;

    public static ItemBasicItemFilter create() {
        ItemBasicItemFilter result = new ItemBasicItemFilter();
        result.init();
        return result;
    }

    protected ItemBasicItemFilter() {
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemBasicFilterUpgrade.unlocalisedName);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setMaxStackSize(64);
        this.icons = new IIcon[2];
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemBasicFilterUpgrade.unlocalisedName);
    }

    @Override
    public IItemFilter createFilterFromStack(ItemStack stack) {
        int damage = MathHelper.clamp_int((int)stack.getItemDamage(), (int)0, (int)1);
        ItemFilter filter = damage == 0 ? new ItemFilter(false) : new ItemFilter(true);
        if (stack.stackTagCompound != null && stack.stackTagCompound.hasKey("filter")) {
            filter.readFromNBT(stack.stackTagCompound.getCompoundTag("filter"));
        }
        return filter;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        damage = MathHelper.clamp_int((int)damage, (int)0, (int)1);
        return this.icons[damage];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister IIconRegister2) {
        this.icons[0] = IIconRegister2.registerIcon("enderio:filterUpgradeBasic");
        this.icons[1] = IIconRegister2.registerIcon("enderio:filterUpgradeAdvanced");
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        int i = MathHelper.clamp_int((int)par1ItemStack.getItemDamage(), (int)0, (int)1);
        return i == 0 ? "enderio.filterUpgradeBasic" : "enderio.filterUpgradeAdvanced";
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < 2; ++j) {
            par3List.add(new ItemStack((Item)this, 1, j));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (FilterRegister.isFilterSet(par1ItemStack)) {
            if (!SpecialTooltipHandler.showAdvancedTooltips()) {
                par3List.add(EnderIO.lang.localize("itemConduitFilterUpgrade"));
                SpecialTooltipHandler.addShowDetailsTooltip((List)par3List);
            } else {
                par3List.add(EnumChatFormatting.ITALIC + EnderIO.lang.localize("itemConduitFilterUpgrade.configured"));
                par3List.add(EnumChatFormatting.ITALIC + EnderIO.lang.localize("itemConduitFilterUpgrade.clearConfigMethod"));
            }
        } else {
            par3List.add(EnderIO.lang.localize("itemConduitFilterUpgrade"));
        }
    }
}

