/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.IItemFilterUpgrade;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;

public class CopyFilterRecipe
implements IRecipe {
    private ItemStack output;

    public boolean matches(InventoryCrafting inv, World world) {
        int blankCount = 0;
        ItemStack filterInput = null;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack checkStack = inv.getStackInSlot(i);
            if (checkStack == null || !(checkStack.getItem() instanceof IItemFilterUpgrade)) continue;
            if (FilterRegister.isFilterSet(checkStack)) {
                if (filterInput != null) {
                    return false;
                }
                filterInput = checkStack;
                continue;
            }
            if (!this.isSameTypeOrNull(filterInput, checkStack)) {
                return false;
            }
            ++blankCount;
        }
        if (blankCount == 0 || filterInput == null) {
            return false;
        }
        this.output = filterInput.copy();
        this.output.stackSize = blankCount + 1;
        return true;
    }

    private boolean isSameTypeOrNull(ItemStack matchOrNull, ItemStack checkStack) {
        return matchOrNull == null || matchOrNull.getItem() == checkStack.getItem() && matchOrNull.getItemDamage() == checkStack.getItemDamage();
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.output.copy();
    }

    public int getRecipeSize() {
        return 1;
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    static {
        RecipeSorter.register((String)"EnderIO:copyFilter", CopyFilterRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }
}

