/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.item.SpeedUpgrade;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;

public class ItemExtractSpeedUpgrade
extends Item
implements IResourceTooltipProvider {
    private static final SpeedUpgrade[] UPGRADES = SpeedUpgrade.values();
    private final IIcon[] icons;

    public static ItemExtractSpeedUpgrade create() {
        ItemExtractSpeedUpgrade result = new ItemExtractSpeedUpgrade();
        result.init();
        return result;
    }

    protected ItemExtractSpeedUpgrade() {
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemExtractSpeedUpgrade.unlocalisedName);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setMaxStackSize(64);
        this.icons = new IIcon[UPGRADES.length];
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemExtractSpeedUpgrade.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        damage = MathHelper.clamp_int((int)damage, (int)0, (int)(this.icons.length - 1));
        return this.icons[damage];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        for (int i = 0; i < UPGRADES.length; ++i) {
            this.icons[i] = iconRegister.registerIcon(ItemExtractSpeedUpgrade.UPGRADES[i].iconName);
        }
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return this.getSpeedUpgrade((ItemStack)par1ItemStack).unlocName;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < UPGRADES.length; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    public SpeedUpgrade getSpeedUpgrade(ItemStack par1ItemStack) {
        int i = MathHelper.clamp_int((int)par1ItemStack.getItemDamage(), (int)0, (int)(UPGRADES.length - 1));
        return UPGRADES[i];
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName(itemStack);
    }
}

