/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.IItemFilterUpgrade;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryUpgrades
implements IInventory {
    IItemConduit itemConduit;
    ForgeDirection dir;

    public InventoryUpgrades(IItemConduit itemConduit, ForgeDirection dir) {
        this.itemConduit = itemConduit;
        this.dir = dir;
    }

    public int getSizeInventory() {
        return 4;
    }

    public ItemStack getStackInSlot(int slot) {
        switch (slot) {
            case 0: {
                return this.itemConduit.getSpeedUpgrade(this.dir);
            }
            case 1: {
                return this.itemConduit.getFunctionUpgrade(this.dir);
            }
            case 2: {
                return this.itemConduit.getInputFilterUpgrade(this.dir);
            }
            case 3: {
                return this.itemConduit.getOutputFilterUpgrade(this.dir);
            }
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int num) {
        ItemStack remaining;
        ItemStack result;
        ItemStack current = this.getStackInSlot(slot);
        if (current == null) {
            return current;
        }
        if (num >= current.stackSize) {
            result = current.copy();
            remaining = null;
        } else {
            result = current.copy();
            result.stackSize = num;
            remaining = current.copy();
            remaining.stackSize -= num;
        }
        this.setInventorySlotContents(slot, remaining);
        return result;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack var2) {
        switch (slot) {
            case 0: {
                this.itemConduit.setSpeedUpgrade(this.dir, var2);
                break;
            }
            case 1: {
                this.itemConduit.setFunctionUpgrade(this.dir, var2);
                break;
            }
            case 2: {
                this.itemConduit.setInputFilterUpgrade(this.dir, var2);
                break;
            }
            case 3: {
                this.itemConduit.setOutputFilterUpgrade(this.dir, var2);
            }
        }
    }

    public String getInventoryName() {
        return "Upgrades";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 15;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        if (item == null) {
            return false;
        }
        switch (slot) {
            case 0: {
                return item.getItem() == EnderIO.itemExtractSpeedUpgrade;
            }
            case 1: {
                return item.getItem() == EnderIO.itemFunctionUpgrade;
            }
            case 2: 
            case 3: {
                return item.getItem() instanceof IItemFilterUpgrade;
            }
        }
        return false;
    }
}

