/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.PacketFluidFilter;
import crazypants.enderio.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LiquidSettings
extends BaseSettingsPanel {
    static final int ID_REDSTONE_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_WHITELIST = GuiExternalConnection.nextButtonId();
    private static final int NEXT_FILTER_ID = 989322;
    private final RedstoneModeButton rsB;
    private final ColorButton colorB;
    private static final String autoExtractStr = EnderIO.lang.localize("gui.conduit.fluid.autoExtract");
    private static final String filterStr = EnderIO.lang.localize("gui.conduit.fluid.filter");
    private final ILiquidConduit conduit;
    private EnderLiquidConduit eConduit;
    private boolean isEnder;
    private static final int filterX = 59;
    private static final int filterY = 63;
    private static final Rectangle filterBounds = new Rectangle(59, 63, 90, 18);
    private GuiToolTip[] filterToolTips;
    private boolean inOutShowIn = true;
    private MultiIconButton inOutNextB;
    private IconButton whiteListB;

    protected LiquidSettings(final GuiExternalConnection gui, IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_FLUID, EnderIO.lang.localize("itemLiquidConduit.name"), gui, con);
        int y;
        int x;
        this.conduit = (ILiquidConduit)con;
        if (con instanceof EnderLiquidConduit) {
            this.eConduit = (EnderLiquidConduit)con;
            this.isEnder = true;
            x = gui.getXSize() - 20;
            y = this.customTop;
            this.inOutNextB = MultiIconButton.createRightArrowButton((IGuiScreen)gui, (int)989322, (int)x, (int)y);
            x = 39;
            y = 64;
            this.whiteListB = new IconButton((IGuiScreen)gui, ID_WHITELIST, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.fluid.whitelist")});
        } else {
            this.isEnder = false;
            gui.getContainer().setInventorySlotsVisible(false);
        }
        x = this.gap + gui.getFontRenderer().getStringWidth(autoExtractStr) + this.gap * 2;
        y = this.customTop;
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, ID_REDSTONE_BUTTON, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                RedstoneControlMode curMode = this.getRedstoneControlMode();
                LiquidSettings.this.conduit.setExtractionRedstoneMode(mode, gui.getDir());
                if (curMode != mode) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(LiquidSettings.this.conduit, gui.getDir()));
                }
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return LiquidSettings.this.conduit.getExtractionRedstoneMode(gui.getDir());
            }
        });
        this.colorB = new ColorButton((IGuiScreen)gui, ID_COLOR_BUTTON, x += this.rsB.getWidth() + this.gap, y);
        this.colorB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.redstone.signalColor"));
        this.colorB.setColorIndex(this.conduit.getExtractionSignalColor(gui.getDir()).ordinal());
    }

    private void addFilterTooltips() {
        this.filterToolTips = new GuiToolTip[5];
        for (int i = 0; i < 5; ++i) {
            Rectangle bound = new Rectangle(59 + i * 18, 63, 18, 18);
            this.filterToolTips[i] = new FilterToolTip(bound, i);
            this.gui.addToolTip(this.filterToolTips[i]);
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.id == ID_COLOR_BUTTON) {
            this.conduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.values()[this.colorB.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.conduit, this.gui.getDir()));
        } else if (guiButton.id == ID_WHITELIST) {
            this.toggleBlacklist();
        } else if (guiButton.id == 989322) {
            boolean bl = this.inOutShowIn = !this.inOutShowIn;
            if (this.isInput()) {
                this.rsB.onGuiInit();
                this.colorB.onGuiInit();
            } else {
                this.rsB.detach();
                this.colorB.detach();
            }
            if (this.isFilterVisible()) {
                this.updateWhiteListButton(this.eConduit.getFilter(this.gui.getDir(), this.isInput()));
            }
        }
    }

    @Override
    protected void connectionModeChanged(ConnectionMode conectionMode) {
        super.connectionModeChanged(conectionMode);
        this.updateGuiVisibility();
    }

    private void toggleBlacklist() {
        if (!this.isFilterVisible()) {
            return;
        }
        FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), this.isInput());
        if (filter == null) {
            filter = new FluidFilter();
        }
        filter.setBlacklist(!filter.isBlacklist());
        this.setConduitFilter(filter);
        this.updateWhiteListButton(filter);
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        if (!this.isFilterVisible()) {
            return;
        }
        if (!filterBounds.contains(x, y)) {
            return;
        }
        ItemStack st = Minecraft.getMinecraft().thePlayer.inventory.getItemStack();
        FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), this.isInput());
        if (filter == null && st == null) {
            return;
        }
        if (filter == null) {
            filter = new FluidFilter();
        }
        int slot = (x - 59) / 18;
        filter.setFluid(slot, st);
        this.setConduitFilter(filter);
    }

    protected void setConduitFilter(FluidFilter filter) {
        this.eConduit.setFilter(this.gui.getDir(), filter, this.isInput());
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFluidFilter(this.eConduit, this.gui.getDir(), filter, this.isInput()));
    }

    @Override
    protected void initCustomOptions() {
        this.updateGuiVisibility();
    }

    private void updateGuiVisibility() {
        this.deactivate();
        if (this.isInput()) {
            this.rsB.onGuiInit();
            this.colorB.onGuiInit();
        }
        if (!this.isEnder) {
            return;
        }
        if (this.isFilterVisible()) {
            this.gui.getContainer().setInventorySlotsVisible(true);
            this.addFilterTooltips();
            this.whiteListB.onGuiInit();
            this.updateWhiteListButton(this.eConduit.getFilter(this.gui.getDir(), this.isInput()));
        } else {
            this.gui.getContainer().setInventorySlotsVisible(false);
        }
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.IN_OUT) {
            this.inOutNextB.onGuiInit();
        }
    }

    private void updateWhiteListButton(FluidFilter filter) {
        if (filter != null && filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.fluid.blacklist")});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.fluid.whitelist")});
        }
    }

    @Override
    public void deactivate() {
        this.rsB.detach();
        this.colorB.detach();
        if (this.isEnder) {
            this.gui.getContainer().setInventorySlotsVisible(false);
            if (this.filterToolTips != null) {
                for (GuiToolTip tt : this.filterToolTips) {
                    if (tt == null) continue;
                    this.gui.removeToolTip(tt);
                }
            }
            this.inOutNextB.detach();
            this.whiteListB.detach();
        }
    }

    @Override
    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
        boolean isInput = this.isInput();
        if (isInput) {
            int x = this.gui.getGuiLeft() + this.gap + this.gui.getFontRenderer().getStringWidth(autoExtractStr) + this.gap + 2;
            int y = top;
            this.gui.getFontRenderer().drawString(autoExtractStr, this.left, y, ColorUtil.getRGB((Color)Color.DARK_GRAY));
        }
        if (this.isEnder && this.isFilterVisible()) {
            if (this.conduit.getConnectionMode(this.gui.getDir()) == ConnectionMode.IN_OUT) {
                String inOutStr = this.inOutShowIn ? EnderIO.lang.localize("gui.conduit.ioMode.input") : EnderIO.lang.localize("gui.conduit.ioMode.output");
                int x = this.gui.getGuiLeft() + this.gui.getXSize() - 20 - 5 - this.gui.getFontRenderer().getStringWidth(inOutStr);
                int y = top;
                this.gui.getFontRenderer().drawString(inOutStr, x, y, ColorUtil.getRGB((Color)Color.DARK_GRAY));
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.bindGuiTexture(1);
            this.gui.drawTexturedModalRect(this.gui.getGuiLeft(), this.gui.getGuiTop() + 55, 0, 55, this.gui.getXSize(), 145);
            FontRenderer fr = this.gui.getFontRenderer();
            int sw = fr.getStringWidth(filterStr);
            int x = this.gui.width / 2 - sw / 2;
            int y = top + 20;
            fr.drawString(filterStr, x, y, ColorUtil.getRGB((Color)Color.DARK_GRAY));
            x = this.gui.getGuiLeft() + 59;
            y = this.gui.getGuiTop() + 63;
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.bindGuiTexture();
            this.gui.drawTexturedModalRect(x, y, 24, 238, 90, 18);
            FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), isInput);
            if (filter != null && !filter.isEmpty()) {
                for (int i = 0; i < filter.size(); ++i) {
                    FluidStack f = filter.getFluidStackAt(i);
                    if (f == null) continue;
                    this.renderFluid(f, x + i * 18, y);
                }
            }
        }
    }

    private void renderFluid(FluidStack f, int x, int y) {
        IIcon icon = f.getFluid().getIcon();
        if (icon != null) {
            RenderUtil.bindBlockTexture();
            int color = f.getFluid().getColor(f);
            GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            this.gui.drawTexturedModelRectFromIcon(x + 1, y + 1, icon, 16, 16);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private boolean isInput() {
        ConnectionMode mode = this.conduit.getConnectionMode(this.gui.getDir());
        return mode == ConnectionMode.IN_OUT && this.inOutShowIn || mode == ConnectionMode.INPUT;
    }

    private boolean isFilterVisible() {
        if (!this.isEnder) {
            return false;
        }
        ConnectionMode mode = this.conduit.getConnectionMode(this.gui.getDir());
        return mode == ConnectionMode.INPUT || mode == ConnectionMode.OUTPUT || mode == ConnectionMode.IN_OUT;
    }

    private class FilterToolTip
    extends GuiToolTip {
        int index;

        public FilterToolTip(Rectangle bounds, int index) {
            super(bounds, (String[])null);
            this.index = index;
        }

        public List<String> getToolTipText() {
            if (!LiquidSettings.this.isFilterVisible()) {
                return null;
            }
            FluidFilter filter = LiquidSettings.this.eConduit.getFilter(LiquidSettings.this.gui.getDir(), LiquidSettings.this.isInput());
            if (filter == null) {
                return null;
            }
            if (filter.getFluidStackAt(this.index) == null) {
                return null;
            }
            return Collections.singletonList(filter.getFluidStackAt(this.index).getLocalizedName());
        }
    }
}

