/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.common.Optional;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gas.IGasConduit;
import crazypants.enderio.conduit.gui.ExternalConnectionContainer;
import crazypants.enderio.conduit.gui.TabFactory;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.me.IMEConduit;
import crazypants.enderio.conduit.oc.IOCConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.gui.IconEIO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiExternalConnection
extends GuiContainerBaseEIO {
    private static final int TAB_HEIGHT = 24;
    private static int nextButtonId = 1;
    private static final Map<Class<? extends IConduit>, Integer> TAB_ORDER = new HashMap<Class<? extends IConduit>, Integer>();
    final InventoryPlayer playerInv;
    final IConduitBundle bundle;
    private final ForgeDirection dir;
    private final List<IConduit> conduits = new ArrayList<IConduit>();
    private final List<ITabPanel> tabs = new ArrayList<ITabPanel>();
    private int activeTab = 0;
    private int tabYOffset = 4;
    private final ExternalConnectionContainer container = (ExternalConnectionContainer)this.inventorySlots;

    public static int nextButtonId() {
        return nextButtonId++;
    }

    public GuiExternalConnection(InventoryPlayer playerInv, IConduitBundle bundle, ForgeDirection dir) {
        super((Container)new ExternalConnectionContainer(playerInv, bundle, dir), "externalConduitConnection", "itemFilter");
        this.playerInv = playerInv;
        this.bundle = bundle;
        this.dir = dir;
        this.ySize = 195;
        this.xSize = 206;
        this.container.setInoutSlotsVisible(false, false);
        this.container.setInventorySlotsVisible(false);
        ArrayList<IConduit> cons = new ArrayList<IConduit>(bundle.getConduits());
        Collections.sort(cons, new Comparator<IConduit>(){

            @Override
            public int compare(IConduit o1, IConduit o2) {
                Integer int1 = (Integer)TAB_ORDER.get(o1.getBaseConduitType());
                if (int1 == null) {
                    return 1;
                }
                Integer int2 = (Integer)TAB_ORDER.get(o2.getBaseConduitType());
                if (int2 == null) {
                    return 1;
                }
                return Double.compare(int1.intValue(), int2.intValue());
            }
        });
        for (IConduit con : cons) {
            ITabPanel tab;
            if (!con.containsExternalConnection(dir) && !con.canConnectToExternal(dir, true) || (tab = TabFactory.instance.createPanelForConduit(this, con)) == null) continue;
            this.conduits.add(con);
            this.tabs.add(tab);
        }
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        ((ExternalConnectionContainer)this.inventorySlots).createGhostSlots(this.getGhostSlots());
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) {
                this.tabs.get(i).onGuiInit(this.guiLeft + 10, this.guiTop, this.xSize - 20, this.ySize - 20);
                continue;
            }
            this.tabs.get(i).deactivate();
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    protected void mouseClicked(int x, int y, int par3) {
        super.mouseClicked(x, y, par3);
        int tabLeftX = this.xSize;
        int tabRightX = tabLeftX + 22;
        int minY = this.tabYOffset;
        int maxY = minY + this.conduits.size() * 24;
        if ((x -= this.guiLeft) > tabLeftX && x < tabRightX + 24 && (y -= this.guiTop) > minY && y < maxY) {
            this.activeTab = (y - minY) / 24;
            this.initGui();
            return;
        }
        this.tabs.get(this.activeTab).mouseClicked(x, y, par3);
    }

    public void setSize(int x, int y) {
        this.xSize = x;
        this.ySize = y;
    }

    protected void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        this.tabs.get(this.activeTab).actionPerformed(guiButton);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        int tabX = sx + this.xSize - 3;
        Tessellator tes = Tessellator.instance;
        tes.startDrawingQuads();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) continue;
            RenderUtil.bindTexture((ResourceLocation)IconEIO.TEXTURE);
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)tabX, (double)(sy + this.tabYOffset + i * 24));
            IWidgetIcon icon = this.tabs.get(i).getIcon();
            icon.getMap().render(icon, (double)(tabX - 1), (double)(sy + this.tabYOffset + i * 24 + 4));
        }
        tes.draw();
        this.bindGuiTexture();
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        RenderUtil.bindTexture((ResourceLocation)IconEIO.TEXTURE);
        tes.startDrawingQuads();
        IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)tabX, (double)(sy + this.tabYOffset + this.activeTab * 24));
        if (this.tabs.size() > 0) {
            IWidgetIcon icon = this.tabs.get(this.activeTab).getIcon();
            icon.getMap().render(icon, (double)(tabX - 1), (double)(sy + this.tabYOffset + this.activeTab * 24 + 4));
            tes.draw();
            this.tabs.get(this.activeTab).render(par1, par2, par3);
        } else {
            tes.draw();
        }
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
    }

    public ForgeDirection getDir() {
        return this.dir;
    }

    public ExternalConnectionContainer getContainer() {
        return this.container;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gc, int x, int y, int w, int h) {
        if (this.tabs.size() > 0) {
            int sx = (this.width - this.xSize) / 2;
            int sy = (this.height - this.ySize) / 2;
            int tabX = sx + this.xSize - 3;
            int tabY = sy + this.tabYOffset;
            return x + w >= tabX && x < tabX + 14 && y + h >= tabY && y < tabY + this.tabs.size() * 24;
        }
        return false;
    }

    protected void drawFakeItemStack(int x, int y, ItemStack stack) {
        super.drawFakeItemStack(x, y, stack);
        itemRender.renderItemOverlayIntoGUI(this.fontRendererObj, this.mc.renderEngine, stack, x, y, "");
    }

    public void clearGhostSlots() {
        this.getGhostSlots().clear();
        ((ExternalConnectionContainer)this.inventorySlots).createGhostSlots(this.getGhostSlots());
    }

    static {
        TAB_ORDER.put(IItemConduit.class, 0);
        TAB_ORDER.put(ILiquidConduit.class, 1);
        TAB_ORDER.put(IRedstoneConduit.class, 2);
        TAB_ORDER.put(IPowerConduit.class, 3);
        TAB_ORDER.put(IMEConduit.class, 4);
        TAB_ORDER.put(IGasConduit.class, 5);
        TAB_ORDER.put(IOCConduit.class, 6);
    }
}

