/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gas.IGasConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import mekanism.api.gas.Gas;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.IIcon;

public class GasSettings
extends BaseSettingsPanel {
    static final int ID_REDSTONE_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private RedstoneModeButton rsB;
    private ColorButton colorB;
    private String autoExtractStr = EnderIO.lang.localize("gui.conduit.gas.autoExtract");
    private IGasConduit conduit;

    protected GasSettings(final GuiExternalConnection gui, IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_GAS, EnderIO.lang.localize("itemGasConduit.name"), gui, con);
        this.conduit = (IGasConduit)con;
        gui.getContainer().setInventorySlotsVisible(false);
        int x = this.gap + gui.getFontRenderer().getStringWidth(this.autoExtractStr) + this.gap * 2;
        int y = this.customTop;
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, ID_REDSTONE_BUTTON, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                RedstoneControlMode curMode = this.getRedstoneControlMode();
                GasSettings.this.conduit.setExtractionRedstoneMode(mode, gui.getDir());
                if (curMode != mode) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(GasSettings.this.conduit, gui.getDir()));
                }
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return GasSettings.this.conduit.getExtractionRedstoneMode(gui.getDir());
            }
        });
        this.colorB = new ColorButton((IGuiScreen)gui, ID_COLOR_BUTTON, x += this.rsB.getWidth() + this.gap, y);
        this.colorB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.redstone.signalColor"));
        this.colorB.setColorIndex(this.conduit.getExtractionSignalColor(gui.getDir()).ordinal());
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.id == ID_COLOR_BUTTON) {
            this.conduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.values()[this.colorB.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.conduit, this.gui.getDir()));
        }
    }

    @Override
    protected void connectionModeChanged(ConnectionMode conectionMode) {
        super.connectionModeChanged(conectionMode);
        if (conectionMode == ConnectionMode.INPUT) {
            this.rsB.onGuiInit();
            this.colorB.onGuiInit();
        } else {
            this.rsB.detach();
            this.colorB.detach();
        }
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.rsB.setToolTip(null);
        this.colorB.setToolTip((String[])null);
    }

    @Override
    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
        boolean isInput = this.isInput();
        if (isInput) {
            int x = this.gui.getGuiLeft() + this.gap + this.gui.getFontRenderer().getStringWidth(this.autoExtractStr) + this.gap + 2;
            int y = this.customTop;
            this.gui.getFontRenderer().drawString(this.autoExtractStr, this.left, top, ColorUtil.getRGB((Color)Color.DARK_GRAY));
        }
    }

    private void renderGas(Gas f, int x, int y) {
        IIcon icon = f.getIcon();
        if (icon != null) {
            RenderUtil.bindBlockTexture();
            this.gui.drawTexturedModelRectFromIcon(x + 1, y + 1, icon, 16, 16);
        }
    }

    private boolean isInput() {
        return this.conduit.getConnectionMode(this.gui.getDir()) == ConnectionMode.INPUT;
    }
}

