/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gas;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gas.AbstractGasTankConduit;
import crazypants.enderio.conduit.gas.AbstractGasTankConduitNetwork;
import crazypants.enderio.conduit.gas.GasConduitNetwork;
import crazypants.enderio.conduit.gas.GasOutput;
import crazypants.enderio.conduit.gas.IGasConduit;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.config.Config;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GasConduit
extends AbstractGasTankConduit {
    public static final int CONDUIT_VOLUME = 1000;
    public static final String ICON_KEY = "enderio:gasConduit";
    public static final String ICON_CORE_KEY = "enderio:gasConduitCore";
    public static final String ICON_EXTRACT_KEY = "enderio:gasConduitInput";
    public static final String ICON_INSERT_KEY = "enderio:gasConduitOutput";
    public static final String ICON_EMPTY_EDGE = "enderio:gasConduitEdge";
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private GasConduitNetwork network;
    private long ticksSinceFailedExtract = 0L;
    public static final int MAX_EXTRACT_PER_TICK = Config.gasConduitExtractRate;
    public static final int MAX_IO_PER_TICK = Config.gasConduitMaxIoRate;

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                ICONS.put(GasConduit.ICON_KEY, register.registerIcon(GasConduit.ICON_KEY));
                ICONS.put(GasConduit.ICON_CORE_KEY, register.registerIcon(GasConduit.ICON_CORE_KEY));
                ICONS.put(GasConduit.ICON_EXTRACT_KEY, register.registerIcon(GasConduit.ICON_EXTRACT_KEY));
                ICONS.put(GasConduit.ICON_INSERT_KEY, register.registerIcon(GasConduit.ICON_INSERT_KEY));
                ICONS.put(GasConduit.ICON_EMPTY_EDGE, register.registerIcon(GasConduit.ICON_EMPTY_EDGE));
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    public GasConduit() {
        this.updateTank();
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (world.isRemote) {
            return;
        }
        this.doExtract();
        if (this.stateDirty) {
            this.getBundle().dirty();
            this.stateDirty = false;
        }
    }

    private void doExtract() {
        BlockCoord loc = this.getLocation();
        if (!this.hasConnectionMode(ConnectionMode.INPUT)) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25L && this.ticksSinceFailedExtract % 10L != 0L) {
            return;
        }
        Gas f = this.tank.getGas() == null ? null : this.tank.getGas().getGas();
        for (ForgeDirection dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir, MAX_EXTRACT_PER_TICK)) continue;
            this.ticksSinceFailedExtract = 0L;
        }
    }

    @Override
    protected void updateTank() {
        this.tank.setCapacity(1000);
        if (this.network != null) {
            this.network.updateConduitVolumes();
        }
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemGasConduit);
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        if (!(network instanceof GasConduitNetwork)) {
            return false;
        }
        GasConduitNetwork n = (GasConduitNetwork)network;
        if (this.tank.getGas() == null) {
            this.tank.setGas(n.getGasType() == null ? null : n.getGasType().copy());
        } else if (n.getGasType() == null) {
            n.setGasType(this.tank.getGas());
        } else if (!this.tank.getGas().isGasEqual(n.getGasType())) {
            return false;
        }
        this.network = n;
        return true;
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        if (!(con instanceof GasConduit)) {
            return false;
        }
        if (this.getGasType() != null && ((GasConduit)con).getGasType() == null) {
            return false;
        }
        return GasConduitNetwork.areGassCompatable(this.getGasType(), ((GasConduit)con).getGasType());
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshInputs(dir);
    }

    private void refreshInputs(ForgeDirection dir) {
        if (this.network == null) {
            return;
        }
        GasOutput lo = new GasOutput(this.getLocation().getLocation(dir), dir.getOpposite());
        this.network.removeInput(lo);
        if (this.getConnectionMode(dir).acceptsOutput() && this.containsExternalConnection(dir)) {
            this.network.addInput(lo);
        }
    }

    @Override
    public void externalConnectionAdded(ForgeDirection fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return ICONS.get(ICON_CORE_KEY);
        }
        return ICONS.get(ICON_KEY);
    }

    public IIcon getTextureForInputMode() {
        return ICONS.get(ICON_EXTRACT_KEY);
    }

    public IIcon getTextureForOutputMode() {
        return ICONS.get(ICON_INSERT_KEY);
    }

    public IIcon getNotSetEdgeTexture() {
        return ICONS.get(ICON_EMPTY_EDGE);
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        if (this.isActive() && this.tank.containsValidGas()) {
            return this.tank.getGas().getGas().getIcon();
        }
        return null;
    }

    @Deprecated
    @Optional.Method(modid="MekanismAPI|gas")
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.network == null || !this.getConnectionMode(side).acceptsInput()) {
            return 0;
        }
        return this.network.fill(side, stack, doTransfer);
    }

    @Deprecated
    @Optional.Method(modid="MekanismAPI|gas")
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        if (this.network == null || !this.getConnectionMode(side).acceptsOutput()) {
            return null;
        }
        return this.network.drain(side, amount, doTransfer);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean canReceiveGas(ForgeDirection from, Gas gas) {
        if (this.network == null) {
            return false;
        }
        return this.getConnectionMode(from).acceptsInput() && GasConduitNetwork.areGassCompatable(this.getGasType(), new GasStack(gas, 0));
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean canDrawGas(ForgeDirection from, Gas gas) {
        if (this.network == null) {
            return false;
        }
        return this.getConnectionMode(from).acceptsOutput() && GasConduitNetwork.areGassCompatable(this.getGasType(), new GasStack(gas, 0));
    }

    @Override
    protected boolean canJoinNeighbour(IGasConduit n) {
        return n instanceof GasConduit;
    }

    @Override
    public AbstractGasTankConduitNetwork<? extends AbstractGasTankConduit> getTankNetwork() {
        return this.network;
    }
}

