/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.conduit.MicroblocksUtil;
import crazypants.enderio.conduit.TileConduitBundle;
import java.util.List;
import mods.immibis.microblocks.api.IMicroblockCoverSystem;
import mods.immibis.microblocks.api.IMicroblockSupporterTile;
import mods.immibis.microblocks.api.MicroblockAPIUtils;
import mods.immibis.microblocks.api.Part;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractItemConduit
extends Item
implements IConduitItem {
    protected ModObject modObj;
    protected ItemConduitSubtype[] subtypes;
    protected IIcon[] icons;

    protected AbstractItemConduit(ModObject modObj, ItemConduitSubtype ... subtypes) {
        this.modObj = modObj;
        this.subtypes = subtypes;
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(modObj.unlocalisedName);
        this.setMaxStackSize(64);
        this.setHasSubtypes(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.modObj.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister IIconRegister2) {
        this.icons = new IIcon[this.subtypes.length];
        int index = 0;
        for (ItemConduitSubtype subtype : this.subtypes) {
            this.icons[index] = IIconRegister2.registerIcon(subtype.iconKey);
            ++index;
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (MicroblocksUtil.supportMicroblocks() && this.tryAddToMicroblocks(stack, player, world, x, y, z, side)) {
            return true;
        }
        BlockCoord placeAt = Util.canPlaceItem((ItemStack)stack, (Block)EnderIO.blockConduitBundle, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z, (int)side);
        if (placeAt != null) {
            TileEntity te;
            if (!world.isRemote && world.setBlock(placeAt.x, placeAt.y, placeAt.z, (Block)EnderIO.blockConduitBundle, 0, 1) && (te = world.getTileEntity(placeAt.x, placeAt.y, placeAt.z)) instanceof IConduitBundle) {
                IConduitBundle bundle = (IConduitBundle)te;
                bundle.addConduit(this.createConduit(stack, player));
                ConduitUtil.playBreakSound(Block.soundTypeMetal, world, placeAt.x, placeAt.y, placeAt.z);
            }
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
            return true;
        }
        ForgeDirection dir = ForgeDirection.values()[side];
        int placeX = x + dir.offsetX;
        int placeY = y + dir.offsetY;
        int placeZ = z + dir.offsetZ;
        if (world.getBlock(placeX, placeY, placeZ) == EnderIO.blockConduitBundle) {
            TileConduitBundle bundle = (TileConduitBundle)world.getTileEntity(placeX, placeY, placeZ);
            if (bundle == null) {
                System.out.println("AbstractItemConduit.onItemUse: Bundle null");
                return false;
            }
            if (!bundle.hasType(this.getBaseConduitType())) {
                if (!world.isRemote) {
                    IConduit con = this.createConduit(stack, player);
                    if (con == null) {
                        System.out.println("AbstractItemConduit.onItemUse: Conduit null.");
                        return false;
                    }
                    bundle.addConduit(con);
                    ConduitUtil.playBreakSound(Block.soundTypeMetal, world, placeX, placeY, placeZ);
                    if (!player.capabilities.isCreativeMode) {
                        --stack.stackSize;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean tryAddToMicroblocks(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te.getClass().getName().equals("mods.immibis.microblocks.TileMicroblockContainer")) {
            IMicroblockCoverSystem covers = ((IMicroblockSupporterTile)te).getCoverSystem();
            world.setBlock(x, y, z, (Block)EnderIO.blockConduitBundle);
            EnderIO.blockConduitBundle.onBlockActivated(world, x, y, z, player, side, 0.0f, 0.0f, 0.0f);
            IMicroblockCoverSystem newCovers = MicroblockAPIUtils.createMicroblockCoverSystem((IMicroblockSupporterTile)((IMicroblockSupporterTile)world.getTileEntity(x, y, z)));
            for (Part p : covers.getAllParts()) {
                newCovers.addPart(p);
            }
            ((TileConduitBundle)world.getTileEntity((int)x, (int)y, (int)z)).covers = newCovers;
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            return false;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te == null || !(te instanceof IConduitBundle)) {
            return false;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        Object existingConduit = bundle.getConduit(this.getBaseConduitType());
        if (existingConduit == null) {
            return false;
        }
        ItemStack existingConduitAsItemStack = existingConduit.createItem();
        if (!ItemUtil.areStacksEqual((ItemStack)existingConduitAsItemStack, (ItemStack)stack)) {
            if (!world.isRemote) {
                IConduit newConduit = this.createConduit(stack, player);
                if (newConduit == null) {
                    System.out.println("AbstractItemConduit.onItemUse: Conduit null.");
                    return false;
                }
                bundle.removeConduit((IConduit)existingConduit);
                bundle.addConduit(newConduit);
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                    for (ItemStack drop : existingConduit.getDrops()) {
                        if (player.inventory.addItemStackToInventory(drop)) continue;
                        ItemUtil.spawnItemInWorldWithRandomMotion((World)world, (ItemStack)drop, (int)x, (int)y, (int)z);
                    }
                    player.inventoryContainer.detectAndSendChanges();
                }
                return true;
            }
            player.swingItem();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        damage = MathHelper.clamp_int((int)damage, (int)0, (int)(this.subtypes.length - 1));
        return this.icons[damage];
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        int i = MathHelper.clamp_int((int)par1ItemStack.getItemDamage(), (int)0, (int)(this.subtypes.length - 1));
        return this.subtypes[i].unlocalisedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < this.subtypes.length; ++j) {
            par3List.add(new ItemStack((Item)this, 1, j));
        }
    }
}

