/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.ContainerTravelAuth;
import crazypants.enderio.teleport.GuiTravelAuth;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.telepad.ContainerTelePad;
import crazypants.enderio.teleport.telepad.GuiAugmentedTravelAccessible;
import crazypants.enderio.teleport.telepad.GuiTelePad;
import crazypants.enderio.teleport.telepad.PacketOpenServerGui;
import crazypants.enderio.teleport.telepad.PacketTeleport;
import crazypants.enderio.teleport.telepad.PacketUpdateCoords;
import crazypants.enderio.teleport.telepad.TileTelePad;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTelePad
extends BlockTravelAnchor {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    @SideOnly(value=Side.CLIENT)
    private IIcon model;
    @SideOnly(value=Side.CLIENT)
    IIcon animationIcon;
    public static int renderId;

    public static BlockTelePad create() {
        BlockTelePad ret = new BlockTelePad();
        PacketHandler.INSTANCE.registerMessage(PacketOpenServerGui.class, PacketOpenServerGui.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpdateCoords.class, PacketUpdateCoords.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpdateCoords.class, PacketUpdateCoords.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketTeleport.class, PacketTeleport.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketTeleport.class, PacketTeleport.class, PacketHandler.nextID(), Side.CLIENT);
        ret.init();
        return ret;
    }

    protected BlockTelePad() {
        super(ModObject.blockTelePad.unlocalisedName, TileTelePad.class);
    }

    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(102, this);
        EnderIO.guiHandler.registerGuiHandler(103, this);
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        this.icons = new IIcon[3];
        this.icons[0] = iIconRegister.func_94245_a("enderio:telePadBottom");
        this.icons[1] = iIconRegister.func_94245_a("enderio:telePadTop");
        this.icons[2] = iIconRegister.func_94245_a("enderio:telePadSide");
        this.model = iIconRegister.func_94245_a("enderio:telePadModel");
    }

    @Override
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileTelePad te = (TileTelePad)world.func_147438_o(x, y, z);
        if (te != null && te.inNetwork()) {
            return this.model;
        }
        return this.func_149691_a(blockSide, 0);
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icons[Math.min(side, 2)];
    }

    @Override
    public int func_149645_b() {
        return renderId;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        AxisAlignedBB bb = super.func_149633_g(world, x, y, z);
        TileTelePad te = (TileTelePad)world.func_147438_o(x, y, z);
        if (!te.inNetwork()) {
            return bb;
        }
        return te.getBoundingBox();
    }

    public void func_149695_a(World world, int x, int y, int z, Block changedTo) {
        super.func_149695_a(world, x, y, z, changedTo);
        ((TileTelePad)world.func_147438_o(x, y, z)).updateRedstoneState();
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        super.onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
        ((TileTelePad)world.func_147438_o(x, y, z)).updateConnectedState(true);
    }

    @Override
    public boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTelePad) {
            TileTelePad tp = (TileTelePad)te;
            if (tp.inNetwork()) {
                if (!tp.isMaster()) {
                    TileTelePad master = tp.getMaster();
                    return this.openGui(world, master.field_145851_c, master.field_145848_d, master.field_145849_e, entityPlayer, side);
                }
            } else {
                return false;
            }
            if (tp.canBlockBeAccessed(entityPlayer)) {
                entityPlayer.openGui((Object)EnderIO.instance, 102, world, x, y, z);
            } else {
                BlockTelePad.sendPrivateChatMessage(entityPlayer, tp.getPlacedBy());
            }
        }
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack par6ItemStack) {
        super.func_149689_a(world, x, y, z, entity, par6ItemStack);
        ((TileTelePad)world.func_147438_o(x, y, z)).updateConnectedState(true);
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTelePad) {
            switch (ID) {
                case 102: {
                    return new ContainerTelePad(player.field_71071_by);
                }
                case 103: {
                    return new ContainerTravelAccessable(player.field_71071_by, (TileTelePad)te, world);
                }
            }
            return new ContainerTravelAuth(player.field_71071_by);
        }
        return null;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTelePad) {
            switch (ID) {
                case 102: {
                    return new GuiTelePad(player.field_71071_by, (TileTelePad)te, world);
                }
                case 103: {
                    return new GuiAugmentedTravelAccessible(player.field_71071_by, (TileTelePad)te, world);
                }
            }
            return new GuiTravelAuth(player, (ITravelAccessable)te, world);
        }
        return null;
    }
}

