/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import com.enderio.core.common.util.Util;
import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.BasicManyToOneRecipe;
import crazypants.enderio.machine.recipe.CustomTagHandler;
import crazypants.enderio.machine.recipe.IManyToOneRecipe;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeConfig;
import crazypants.enderio.machine.recipe.RecipeConfigParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ManyToOneRecipeManager {
    private final List<IManyToOneRecipe> recipes = new ArrayList<IManyToOneRecipe>();
    private final String coreFileName;
    private final String customFileName;
    private final String managerName;

    public ManyToOneRecipeManager(String coreFileName, String custonFileName, String managerName) {
        this.coreFileName = coreFileName;
        this.customFileName = custonFileName;
        this.managerName = managerName;
    }

    public void loadRecipesFromConfig() {
        CustomTagHandler tagHandler = this.createCustomTagHandler();
        RecipeConfig config = RecipeConfig.loadRecipeConfig(this.coreFileName, this.customFileName, tagHandler);
        if (config != null) {
            this.processConfig(config);
            if (tagHandler != null) {
                tagHandler.configProcessed();
            }
        } else {
            Log.error("Could not load recipes for " + this.managerName + ".");
        }
    }

    protected CustomTagHandler createCustomTagHandler() {
        return null;
    }

    public void addCustomRecipes(String xmlDef) {
        RecipeConfig config;
        CustomTagHandler tagHandler = this.createCustomTagHandler();
        try {
            config = RecipeConfigParser.parse(xmlDef, tagHandler);
        }
        catch (Exception e) {
            Log.error("Error parsing custom xml for " + this.managerName);
            return;
        }
        if (config == null) {
            Log.error("Could not process custom XML " + this.managerName);
            return;
        }
        this.processConfig(config);
        if (tagHandler != null) {
            tagHandler.configProcessed();
        }
    }

    public List<IManyToOneRecipe> getRecipes() {
        return this.recipes;
    }

    private void processConfig(RecipeConfig config) {
        if (config.isDumpItemRegistery()) {
            Util.dumpModObjects((File)new File(Config.configDirectory, "modObjectsRegistery.txt"));
        }
        if (config.isDumpOreDictionary()) {
            Util.dumpOreNames((File)new File(Config.configDirectory, "oreDictionaryRegistery.txt"));
        }
        List<Recipe> newRecipes = config.getRecipes(false);
        Log.info("Found " + newRecipes.size() + " valid " + this.managerName + " recipes in config.");
        for (Recipe rec : newRecipes) {
            this.addRecipe(new BasicManyToOneRecipe(rec));
        }
        Log.info("Finished processing " + this.managerName + " recipes. " + this.recipes.size() + " recipes avaliable.");
    }

    public void addRecipe(IManyToOneRecipe recipe) {
        if (recipe == null) {
            Log.debug("Could not add invalid recipe: " + recipe + " for " + this.managerName);
            return;
        }
        IRecipe rec = this.getRecipeForInputs(recipe.getInputStacks());
        if (rec != null) {
            Log.warn("Not adding supplied recipe to " + this.managerName + " as a recipe already exists for the inputs: " + recipe);
            return;
        }
        this.recipes.add(recipe);
    }

    private IRecipe getRecipeForInputs(List<ItemStack> inputs) {
        MachineRecipeInput[] ins = new MachineRecipeInput[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            ins[i] = new MachineRecipeInput(-1, inputs.get(i));
        }
        return this.getRecipeForInputs(ins);
    }

    public IRecipe getRecipeForInputs(MachineRecipeInput[] inputs) {
        for (IManyToOneRecipe rec : this.recipes) {
            if (!rec.isInputForRecipe(inputs)) continue;
            return rec;
        }
        return null;
    }

    public boolean isValidInput(MachineRecipeInput input) {
        if (input == null || input.item == null) {
            return false;
        }
        for (IManyToOneRecipe recipe : this.recipes) {
            for (RecipeInput ri : recipe.getInputs()) {
                if (!ri.isInput(input.item) || ri.getSlotNumber() != -1 && input.slotNumber != ri.getSlotNumber()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidRecipeComponents(ItemStack[] inputs) {
        if (inputs == null || inputs.length == 0) {
            return false;
        }
        for (IManyToOneRecipe recipe : this.recipes) {
            if (!recipe.isValidRecipeComponents(inputs)) continue;
            return true;
        }
        return false;
    }

    public float getExperianceForOutput(ItemStack output) {
        for (IManyToOneRecipe recipe : this.recipes) {
            if (recipe.getOutput().func_77973_b() != output.func_77973_b() || recipe.getOutput().func_77960_j() != output.func_77960_j()) continue;
            return recipe.getOutputs()[0].getExperiance();
        }
        return 0.0f;
    }
}

