/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.weather;

import com.enderio.core.api.common.util.IProgressTile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.obelisk.weather.PacketActivateWeather;
import crazypants.enderio.machine.obelisk.weather.PacketFinishWeather;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.storage.WorldInfo;

public class TileWeatherObelisk
extends AbstractPowerConsumerEntity
implements IProgressTile {
    int powerUsed = 0;
    private float progress = 0.0f;
    WeatherTask activeTask = null;
    private Color particleColor;
    private boolean canBeActive = true;
    private static int biggestPowerReq = Math.max(Math.max(Config.weatherObeliskClearPower, Config.weatherObeliskThunderPower), Config.weatherObeliskRainPower);
    private static final BasicCapacitor cap = new BasicCapacitor(biggestPowerReq / 200, biggestPowerReq);
    private int activeParticleTicks = 0;

    public TileWeatherObelisk() {
        super(new SlotDefinition(1, 0, 0));
    }

    @Override
    public void init() {
        this.setCapacitor(Capacitors.ACTIVATED_CAPACITOR);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.field_145850_b.field_72995_K && this.activeParticleTicks > 0) {
            this.spawnParticle();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticle() {
        EntitySmokeFX fx = new EntitySmokeFX(this.func_145831_w(), (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.3, (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
        fx.func_70538_b((float)this.particleColor.getRed() / 255.0f, (float)this.particleColor.getGreen() / 255.0f, (float)this.particleColor.getBlue() / 255.0f);
        fx.func_70016_h(this.field_145850_b.field_73012_v.nextDouble() * 0.1 - 0.05, 0.35, this.field_145850_b.field_73012_v.nextDouble() * 0.1 - 0.05);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        --this.activeParticleTicks;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockWeatherObelisk.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        for (WeatherTask task : WeatherTask.values()) {
            if (!task.isValid(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.canBeActive && this.activeTask != null;
    }

    public float getProgress() {
        return this.isActive() ? (this.field_145850_b.field_72995_K ? this.progress : (float)this.powerUsed / (float)this.activeTask.power) : 0.0f;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    protected int getProgressUpdateFreq() {
        return 5;
    }

    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public ICapacitor getCapacitor() {
        return cap;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        boolean res = false;
        if (!redstoneCheckPassed) {
            if (this.canBeActive) {
                this.canBeActive = false;
                res = true;
            }
            return res;
        }
        this.canBeActive = true;
        if (this.isActive()) {
            if (this.getEnergyStored() > this.getPowerUsePerTick()) {
                int remaining = this.activeTask.power - this.powerUsed;
                int toUse = Math.min(remaining, this.getPowerUsePerTick());
                this.setEnergyStored(this.getEnergyStored() - toUse);
                this.powerUsed += toUse;
                res = true;
            }
            if (this.powerUsed >= this.activeTask.power) {
                this.activeTask.complete((TileEntity)this);
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketFinishWeather(this, this.activeTask), this.field_145850_b.field_73011_w.field_76574_g);
                this.startTask(-1);
                res = true;
            }
        }
        return res;
    }

    public boolean canStartTask(WeatherTask task) {
        return this.activeTask == null && task.isValid(this.inventory[this.getSlotDefinition().minInputSlot]);
    }

    public boolean startTask(int taskid) {
        if (this.activeTask == null && taskid >= 0) {
            this.powerUsed = 0;
            WeatherTask task = WeatherTask.values()[taskid];
            if (this.canStartTask(task)) {
                this.activeTask = task;
                this.func_70298_a(this.slotDefinition.minInputSlot, 1);
                return true;
            }
        } else if (this.activeTask != null && taskid == -1) {
            this.activeTask = null;
            this.powerUsed = 0;
            if (!this.field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketActivateWeather(this, null), this.field_145850_b.field_73011_w.field_76574_g);
            }
            return true;
        }
        return false;
    }

    public void activateClientParticles(WeatherTask task) {
        this.activeParticleTicks = 20;
        this.particleColor = task.color;
    }

    public static enum WeatherTask {
        CLEAR(Config.weatherObeliskClearPower, Color.YELLOW){

            @Override
            void complete(TileEntity te) {
                this.rain(te, false);
                this.thunder(te, false);
            }
        }
        ,
        RAIN(Config.weatherObeliskRainPower, new Color(120, 120, 255)){

            @Override
            void complete(TileEntity te) {
                this.rain(te, true);
                this.thunder(te, false);
            }
        }
        ,
        STORM(Config.weatherObeliskThunderPower, Color.DARK_GRAY){

            @Override
            void complete(TileEntity te) {
                this.rain(te, true);
                this.thunder(te, true);
            }
        };

        final int power;
        private ItemStack requiredItem;
        final Color color;

        private WeatherTask(int power, Color color) {
            this.power = power;
            this.color = color;
        }

        abstract void complete(TileEntity var1);

        void rain(TileEntity te, boolean state) {
            te.func_145831_w().func_72912_H().func_76084_b(state);
        }

        void thunder(TileEntity te, boolean state) {
            te.func_145831_w().func_72912_H().func_76069_a(state);
        }

        public boolean isValid(ItemStack item) {
            return item != null && ItemStack.func_77989_b((ItemStack)item, (ItemStack)this.requiredItem);
        }

        public ItemStack requiredItem() {
            return this.requiredItem;
        }

        public void setRequiredItem(ItemStack item) {
            this.requiredItem = item;
        }

        public static boolean worldIsState(WeatherTask task, WorldInfo world) {
            if (world.func_76059_o()) {
                return world.func_76061_m() ? task == STORM : task == RAIN;
            }
            return task == CLEAR;
        }
    }
}

