/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.EnderIO;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.upgrade.ApiaristArmorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.GliderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IDarkSteelUpgrade;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.NaturalistEyeUpgrade;
import crazypants.enderio.item.darksteel.upgrade.NightVisionUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SolarUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SoundDetectorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpoonUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SwimUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TravelUpgrade;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.thaumcraft.ThaumcraftCompat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.AnvilUpdateEvent;

public class DarkSteelRecipeManager {
    public static DarkSteelRecipeManager instance = new DarkSteelRecipeManager();
    private List<IDarkSteelUpgrade> upgrades = new ArrayList<IDarkSteelUpgrade>();

    public DarkSteelRecipeManager() {
        this.upgrades.add(EnergyUpgrade.EMPOWERED);
        this.upgrades.add(EnergyUpgrade.EMPOWERED_TWO);
        this.upgrades.add(EnergyUpgrade.EMPOWERED_THREE);
        this.upgrades.add(EnergyUpgrade.EMPOWERED_FOUR);
        this.upgrades.add(JumpUpgrade.JUMP_ONE);
        this.upgrades.add(JumpUpgrade.JUMP_TWO);
        this.upgrades.add(JumpUpgrade.JUMP_THREE);
        this.upgrades.add(SpeedUpgrade.SPEED_ONE);
        this.upgrades.add(SpeedUpgrade.SPEED_TWO);
        this.upgrades.add(SpeedUpgrade.SPEED_THREE);
        this.upgrades.add(GliderUpgrade.INSTANCE);
        this.upgrades.add(SoundDetectorUpgrade.INSTANCE);
        this.upgrades.add(SwimUpgrade.INSTANCE);
        this.upgrades.add(NightVisionUpgrade.INSTANCE);
        this.upgrades.add(TravelUpgrade.INSTANCE);
        this.upgrades.add(SpoonUpgrade.INSTANCE);
        this.upgrades.add(SolarUpgrade.SOLAR_ONE);
        this.upgrades.add(SolarUpgrade.SOLAR_TWO);
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            ThaumcraftCompat.loadUpgrades(this.upgrades);
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            this.upgrades.add(NaturalistEyeUpgrade.INSTANCE);
            this.upgrades.add(ApiaristArmorUpgrade.HELMET);
            this.upgrades.add(ApiaristArmorUpgrade.CHEST);
            this.upgrades.add(ApiaristArmorUpgrade.LEGS);
            this.upgrades.add(ApiaristArmorUpgrade.BOOTS);
        }
    }

    @SubscribeEvent
    public void handleAnvilEvent(AnvilUpdateEvent evt) {
        if (evt.left == null || evt.right == null) {
            return;
        }
        if (evt.left.func_77973_b() instanceof IDarkSteelItem && OreDictionaryHelper.hasName((ItemStack)evt.right, (String)Alloy.DARK_STEEL.oreIngot)) {
            this.handleRepair(evt);
        } else {
            this.handleUpgrade(evt);
        }
    }

    private void handleRepair(AnvilUpdateEvent evt) {
        ItemStack targetStack = evt.left;
        ItemStack ingots = evt.right;
        IDarkSteelItem targetItem = (IDarkSteelItem)targetStack.func_77973_b();
        int maxIngots = targetItem.getIngotsRequiredForFullRepair();
        double damPerc = (double)targetStack.func_77960_j() / (double)targetStack.func_77958_k();
        int requiredIngots = (int)Math.ceil(damPerc * (double)maxIngots);
        if (ingots.field_77994_a > requiredIngots) {
            return;
        }
        int damageAddedPerIngot = (int)Math.ceil((double)targetStack.func_77958_k() / (double)maxIngots);
        int totalDamageRemoved = damageAddedPerIngot * ingots.field_77994_a;
        ItemStack resultStack = targetStack.func_77946_l();
        resultStack.func_77964_b(Math.max(0, resultStack.func_77960_j() - totalDamageRemoved));
        evt.output = resultStack;
        evt.cost = ingots.field_77994_a + (int)Math.ceil(DarkSteelRecipeManager.getEnchantmentRepairCost(resultStack) / 2);
    }

    private void handleUpgrade(AnvilUpdateEvent evt) {
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (!upgrade.isUpgradeItem(evt.right) || !upgrade.canAddToItem(evt.left)) continue;
            ItemStack res = new ItemStack(evt.left.func_77973_b(), 1, evt.left.func_77960_j());
            if (evt.left.field_77990_d != null) {
                res.field_77990_d = (NBTTagCompound)evt.left.field_77990_d.func_74737_b();
            }
            upgrade.writeToItem(res);
            evt.output = res;
            evt.cost = upgrade.getLevelCost();
            return;
        }
    }

    public static int getEnchantmentRepairCost(ItemStack itemStack) {
        int res = 0;
        Map map1 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        Iterator iter = map1.keySet().iterator();
        while (iter.hasNext()) {
            int i1 = (Integer)iter.next();
            Enchantment enchantment = Enchantment.field_77331_b[i1];
            int level = (Integer)map1.get(i1);
            if (!enchantment.func_92089_a(itemStack)) continue;
            if (level > enchantment.func_77325_b()) {
                level = enchantment.func_77325_b();
            }
            int costPerLevel = 0;
            switch (enchantment.func_77324_c()) {
                case 1: {
                    costPerLevel = 8;
                    break;
                }
                case 2: {
                    costPerLevel = 4;
                }
                default: {
                    break;
                }
                case 5: {
                    costPerLevel = 2;
                    break;
                }
                case 10: {
                    costPerLevel = 1;
                }
            }
            res += costPerLevel * level;
        }
        return res;
    }

    public List<IDarkSteelUpgrade> getUpgrades() {
        return this.upgrades;
    }

    public void addCommonTooltipEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (!upgrade.hasUpgrade(itemstack)) continue;
            upgrade.addCommonEntries(itemstack, entityplayer, list, flag);
        }
    }

    public void addBasicTooltipEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (!upgrade.hasUpgrade(itemstack)) continue;
            upgrade.addBasicEntries(itemstack, entityplayer, list, flag);
        }
    }

    public void addAdvancedTooltipEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        ArrayList<IDarkSteelUpgrade> applyableUpgrades = new ArrayList<IDarkSteelUpgrade>();
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (upgrade.hasUpgrade(itemstack)) {
                upgrade.addDetailedEntries(itemstack, entityplayer, list, flag);
                continue;
            }
            if (!upgrade.canAddToItem(itemstack)) continue;
            applyableUpgrades.add(upgrade);
        }
        if (!applyableUpgrades.isEmpty()) {
            list.add(EnumChatFormatting.YELLOW + EnderIO.lang.localize("tooltip.anvilupgrades") + " ");
            for (IDarkSteelUpgrade up : applyableUpgrades) {
                list.add(EnumChatFormatting.DARK_AQUA + "" + "" + EnderIO.lang.localizeExact(up.getUnlocalizedName() + ".name") + ": ");
                list.add(EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.ITALIC + "  " + up.getUpgradeItemName() + " + " + up.getLevelCost() + " " + EnderIO.lang.localize("item.darkSteel.tooltip.lvs"));
            }
        }
    }

    public Iterator<IDarkSteelUpgrade> recipeIterator() {
        return ImmutableList.copyOf(this.upgrades).iterator();
    }
}

