/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import crazypants.enderio.item.PacketMagnetState;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.BaublesUtil;
import crazypants.util.BotaniaUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class MagnetController
implements IEntitySelector {
    private static List<Item> blacklist = null;

    public MagnetController() {
        PacketHandler.INSTANCE.registerMessage(PacketMagnetState.class, PacketMagnetState.class, PacketHandler.nextID(), Side.SERVER);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ActiveMagnet mag = this.getActiveMagnet(event.player);
        if (mag != null && event.player.func_110143_aJ() > 0.0f) {
            this.doHoover(event.player);
            if (event.side == Side.SERVER && event.player.field_70170_p.func_82737_E() % 20L == 0L) {
                ItemMagnet.drainPerSecondPower(mag.item);
                event.player.field_71071_by.func_70299_a(mag.slot, mag.item);
                event.player.field_71071_by.func_70296_d();
            }
        }
    }

    private ActiveMagnet getActiveMagnet(EntityPlayer player) {
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        int maxSlot = Config.magnetAllowInMainInventory ? 36 : 9;
        for (int i = 0; i < maxSlot; ++i) {
            if (!ItemMagnet.isActive(inv[i]) || !ItemMagnet.hasPower(inv[i])) continue;
            return new ActiveMagnet(inv[i], i);
        }
        return null;
    }

    public void doHoover(EntityPlayer player) {
        if (blacklist == null) {
            MagnetController.initBlacklist();
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)Config.magnetRange), (double)(player.field_70163_u - (double)Config.magnetRange), (double)(player.field_70161_v - (double)Config.magnetRange), (double)(player.field_70165_t + (double)Config.magnetRange), (double)(player.field_70163_u + (double)Config.magnetRange), (double)(player.field_70161_v + (double)Config.magnetRange));
        List interestingItems = player.field_70170_p.func_82733_a(EntityItem.class, aabb, (IEntitySelector)this);
        List xp = player.field_70170_p.func_82733_a(EntityXPOrb.class, aabb, (IEntitySelector)this);
        if (!xp.isEmpty()) {
            interestingItems.addAll(xp);
        }
        for (Entity entity : interestingItems) {
            double x = player.field_70165_t + 0.5 - entity.field_70165_t;
            double y = player.field_70163_u + 1.0 - entity.field_70163_u;
            double z = player.field_70161_v + 0.5 - entity.field_70161_v;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.25) {
                entity.func_70100_b_(player);
                continue;
            }
            double speed = 0.035;
            entity.field_70159_w += x / distance * speed;
            entity.field_70181_x += y * speed;
            if (y > 0.0) {
                entity.field_70181_x = 0.12;
            }
            entity.field_70179_y += z / distance * speed;
        }
    }

    private static void initBlacklist() {
        blacklist = new ArrayList<Item>();
        for (String name : Config.magnetBlacklist) {
            Item item;
            String[] parts = name.split(":");
            if (parts.length != 2 || (item = GameRegistry.findItem((String)parts[0], (String)parts[1])) == null) continue;
            blacklist.add(item);
        }
    }

    public boolean func_82704_a(Entity var1) {
        if (var1.field_70128_L) {
            return false;
        }
        if (var1 instanceof EntityItem) {
            if (!blacklist.isEmpty()) {
                Item item = ((EntityItem)var1).func_92059_d().func_77973_b();
                for (Item blacklisted : blacklist) {
                    if (blacklisted != item) continue;
                    return false;
                }
            }
            return !BotaniaUtil.hasSolegnoliaAround(var1);
        }
        return true;
    }

    public static void setMagnetActive(EntityPlayerMP player, PacketMagnetState.SlotType type, int slot, boolean isActive) {
        ItemStack stack = null;
        IInventory baubles = null;
        int dropOff = -1;
        switch (type) {
            case INVENTORY: {
                stack = player.field_71071_by.func_70301_a(slot);
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles == null) break;
                stack = baubles.func_70301_a(slot);
            }
        }
        if (stack == null || stack.func_77973_b() == null || stack.func_77973_b() != DarkSteelItems.itemMagnet || ItemMagnet.isActive(stack) == isActive) {
            return;
        }
        if (!Config.magnetAllowDeactivatedInBaublesSlot && type == PacketMagnetState.SlotType.BAUBLES && !isActive) {
            ItemStack[] inv = player.field_71071_by.field_70462_a;
            for (int i = 0; i < inv.length && dropOff < 0; ++i) {
                if (inv[i] != null) continue;
                dropOff = i;
            }
            if (dropOff < 0) {
                return;
            }
        }
        ItemMagnet.setActive(stack, isActive);
        switch (type) {
            case INVENTORY: {
                player.field_71071_by.func_70299_a(slot, stack);
                player.field_71071_by.func_70296_d();
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                if (dropOff < 0) {
                    baubles.func_70299_a(slot, stack);
                } else {
                    baubles.func_70299_a(slot, null);
                    player.field_71071_by.func_70299_a(dropOff, stack);
                }
                player.field_71071_by.func_70296_d();
            }
        }
    }

    private static class ActiveMagnet {
        ItemStack item;
        int slot;

        ActiveMagnet(ItemStack item, int slot) {
            this.item = item;
            this.slot = slot;
        }
    }
}

