/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.conduit.gas.GasUtil;
import crazypants.enderio.conduit.me.MEUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public enum ConduitDisplayMode {
    ALL,
    POWER,
    REDSTONE,
    FLUID,
    ITEM,
    GAS,
    ME,
    NONE;

    private static final String NBT_KEY = "enderio.displaymode";

    public static ConduitDisplayMode next(ConduitDisplayMode mode) {
        ConduitDisplayMode res;
        int index = mode.ordinal() + 1;
        if (index >= ConduitDisplayMode.values().length) {
            index = 0;
        }
        if ((res = ConduitDisplayMode.values()[index]) == GAS && !GasUtil.isGasConduitEnabled()) {
            return ConduitDisplayMode.next(res);
        }
        if (res == ME && !MEUtil.isMEEnabled()) {
            return ConduitDisplayMode.next(res);
        }
        return res;
    }

    public static ConduitDisplayMode previous(ConduitDisplayMode mode) {
        ConduitDisplayMode res;
        int index = mode.ordinal() - 1;
        if (index < 0) {
            index = ConduitDisplayMode.values().length - 1;
        }
        if ((res = ConduitDisplayMode.values()[index]) == GAS && !GasUtil.isGasConduitEnabled()) {
            return ConduitDisplayMode.previous(res);
        }
        if (res == ME && !MEUtil.isMEEnabled()) {
            return ConduitDisplayMode.previous(res);
        }
        return res;
    }

    public static ConduitDisplayMode getDisplayMode(ItemStack equipped) {
        if (equipped == null || !(equipped.func_77973_b() instanceof IConduitControl)) {
            return ALL;
        }
        ConduitDisplayMode.initDisplayModeTag(equipped);
        int index = equipped.field_77990_d.func_74762_e(NBT_KEY);
        index = MathHelper.func_76125_a((int)index, (int)0, (int)(ConduitDisplayMode.values().length - 1));
        return ConduitDisplayMode.values()[index];
    }

    public static void setDisplayMode(ItemStack equipped, ConduitDisplayMode mode) {
        if (mode == null || equipped == null || !(equipped.func_77973_b() instanceof IConduitControl)) {
            return;
        }
        ConduitDisplayMode.initDisplayModeTag(equipped);
        equipped.field_77990_d.func_74768_a(NBT_KEY, mode.ordinal());
    }

    private static void initDisplayModeTag(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a(NBT_KEY, ALL.ordinal());
        }
    }

    public ConduitDisplayMode next() {
        return ConduitDisplayMode.next(this);
    }

    public ConduitDisplayMode previous() {
        return ConduitDisplayMode.previous(this);
    }
}

