/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class BaublesUtil {
    private static final BaublesUtil instance = new BaublesUtil();
    private static final boolean baublesLoaded = Loader.isModLoaded((String)"Baubles");

    private BaublesUtil() {
    }

    public static BaublesUtil instance() {
        return instance;
    }

    public boolean hasBaubles() {
        return baublesLoaded;
    }

    public IInventory getBaubles(EntityPlayer player) {
        return this.hasBaubles() ? this.getBaublesInvUnsafe(player) : null;
    }

    private IInventory getBaublesInvUnsafe(EntityPlayer player) {
        return BaublesApi.getBaubles((EntityPlayer)player);
    }

    public static enum WhoAmI {
        SPCLIENT,
        MPCLIENT,
        SPSERVER,
        MPSERVER,
        OTHER;


        public static WhoAmI whoAmI(World world) {
            Side side = FMLCommonHandler.instance().getSide();
            if (side == Side.CLIENT) {
                if (Minecraft.getMinecraft().isIntegratedServerRunning()) {
                    if (world.isRemote) {
                        return SPCLIENT;
                    }
                    return SPSERVER;
                }
                return MPCLIENT;
            }
            if (side == Side.SERVER) {
                if (MinecraftServer.getServer().isDedicatedServer()) {
                    return MPSERVER;
                }
                if (Minecraft.getMinecraft().isIntegratedServerRunning()) {
                    return SPSERVER;
                }
            }
            return OTHER;
        }
    }
}

