/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.xp;

import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.EnderIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketExperianceContainer
extends MessageTileEntity<TileEntity>
implements IMessageHandler<PacketExperianceContainer, IMessage> {
    private static boolean registered = false;
    private ExperienceContainer xpCon;

    public static void register() {
        if (!registered) {
            PacketHandler.INSTANCE.registerMessage(PacketExperianceContainer.class, PacketExperianceContainer.class, PacketHandler.nextID(), Side.CLIENT);
            registered = true;
        }
    }

    public PacketExperianceContainer() {
        this.xpCon = new ExperienceContainer();
    }

    public PacketExperianceContainer(TileEntity tile) {
        super(tile);
        IHaveExperience xpTile = (IHaveExperience)tile;
        this.xpCon = xpTile.getContainer();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.xpCon.toBytes(buf);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.xpCon.fromBytes(buf);
    }

    public IMessage onMessage(PacketExperianceContainer message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileEntity tile = message.getTileEntity(player.worldObj);
        if (tile instanceof IHaveExperience) {
            IHaveExperience xpTile = (IHaveExperience)tile;
            xpTile.getContainer().set(message.xpCon);
        }
        return null;
    }
}

