/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import cofh.api.energy.EnergyStorage;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.rail.TeleporterEIO;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.enderio.teleport.telepad.BlockTelePad;
import crazypants.enderio.teleport.telepad.PacketTeleport;
import crazypants.enderio.teleport.telepad.PacketUpdateCoords;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTelePad
extends TileTravelAnchor
implements IInternalPowerReceiver,
ITelePad,
IProgressTile {
    private boolean inNetwork;
    EnumSet<ForgeDirection> connections = EnumSet.noneOf(ForgeDirection.class);
    private EnergyStorage energy = new EnergyStorage(100000, 1000, 1000);
    private TileTelePad master = null;
    private boolean autoUpdate = false;
    private boolean coordsChanged = false;
    private BlockCoord target = new BlockCoord();
    private int targetDim = Integer.MIN_VALUE;
    private int lastSyncPowerStored;
    private Queue<Entity> toTeleport = Queues.newArrayDeque();
    private int powerUsed;
    private int maxPower;
    private static final ResourceLocation activeRes = AbstractMachineEntity.getSoundFor("telepad.active");
    private MachineSound activeSound = null;
    private boolean redstoneActivePrev;
    public static final String TELEPORTING_KEY = "eio:teleporting";
    public static final String PROGRESS_KEY = "teleportprogress";
    boolean wasBlocked = false;
    public float[] bladeRots = new float[3];
    public float spinSpeed = 0.0f;
    public float speedMult = 2.5f;

    public void doUpdate() {
        super.doUpdate();
        if (this.master != null && this.master.isInvalid()) {
            this.master.breakNetwork();
        }
        if (this.autoUpdate) {
            this.updateConnectedState(true);
            this.autoUpdate = false;
        }
        if (this.targetDim == Integer.MIN_VALUE) {
            this.targetDim = this.worldObj.provider.dimensionId;
        }
        if (this.worldObj.isRemote && this.isMaster()) {
            this.updateRotations();
            if (this.activeSound != null) {
                this.activeSound.setPitch(MathHelper.clamp_float((float)(0.5f + this.spinSpeed / 1.5f), (float)0.5f, (float)2.0f));
            }
            if (this.active()) {
                if (this.activeSound == null) {
                    this.activeSound = new MachineSound(activeRes, this.xCoord, this.yCoord, this.zCoord, 0.01f, 1.0f);
                    this.playSound();
                }
                this.activeSound.setVolume(MathHelper.clamp_float((float)this.spinSpeed, (float)0.1f, (float)1.0f));
                this.updateQueuedEntities();
            } else if (!this.active() && this.activeSound != null) {
                if (this.activeSound.getVolume() <= 0.1f) {
                    this.activeSound.endPlaying();
                    this.activeSound = null;
                } else {
                    this.activeSound.setVolume(MathHelper.clamp_float((float)this.spinSpeed, (float)0.1f, (float)1.0f));
                }
            }
        } else if (!this.worldObj.isRemote) {
            boolean powerChanged;
            if (this.active()) {
                if (this.powerUsed >= this.maxPower) {
                    this.teleport(this.toTeleport.poll());
                    this.powerUsed = 0;
                } else {
                    this.powerUsed += this.energy.extractEnergy(this.getUsage(), false);
                }
                if (this.shouldDoWorkThisTick(5)) {
                    this.updateQueuedEntities();
                }
            }
            boolean bl = powerChanged = this.lastSyncPowerStored != this.getEnergyStored() && this.shouldDoWorkThisTick(5);
            if (powerChanged) {
                this.lastSyncPowerStored = this.getEnergyStored();
                PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this);
            }
            if (this.coordsChanged && this.inNetwork() && this.master != null && this.isMaster()) {
                this.coordsChanged = false;
                PacketHandler.sendToAllAround((IMessage)new PacketUpdateCoords(this.master, this.master.getX(), this.master.getY(), this.master.getZ(), this.master.getTargetDim()), (TileEntity)this.master);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound() {
        FMLClientHandler.instance().getClient().getSoundHandler().playSound((ISound)this.activeSound);
    }

    private void updateQueuedEntities() {
        if (this.worldObj.isRemote && this.active()) {
            this.getCurrentTarget().getEntityData().setFloat(PROGRESS_KEY, this.getProgress());
        }
        ArrayList toRemove = Lists.newArrayList();
        for (Entity e : this.toTeleport) {
            if (this.isEntityInRange(e) && !e.isDead) continue;
            toRemove.add(e);
        }
        for (Entity e : toRemove) {
            this.dequeueTeleport(e, true);
        }
    }

    public void updateConnectedState(boolean fromBlock) {
        for (BlockCoord bc : this.getSurroundingCoords()) {
            TileEntity te = bc.getTileEntity((IBlockAccess)this.worldObj);
            ForgeDirection con = Util.getDirFromOffset((int)(this.xCoord - bc.x), (int)0, (int)(this.zCoord - bc.z));
            if (te instanceof TileTelePad) {
                if (((TileTelePad)te).isMaster() && fromBlock) {
                    ((TileTelePad)te).updateConnectedState(false);
                    return;
                }
                if (con == ForgeDirection.UNKNOWN || ((TileTelePad)te).inNetwork) continue;
                this.connections.add(con);
                continue;
            }
            this.connections.remove(con);
            if (this.master == this) {
                this.breakNetwork();
                this.updateBlock();
                continue;
            }
            if (con == ForgeDirection.UNKNOWN || !this.inNetwork || this.master == null || !fromBlock) continue;
            this.master.updateConnectedState(false);
        }
        if (this.isMaster() && !this.inNetwork) {
            this.inNetwork = this.formNetwork();
            this.updateBlock();
            if (this.inNetwork && this.target.equals((Object)new BlockCoord())) {
                this.target = new BlockCoord((TileEntity)this);
            }
        }
    }

    public void updateRedstoneState() {
        if (!this.inNetwork()) {
            return;
        }
        boolean redstone = this.isPoweredRedstone();
        if (!this.master.redstoneActivePrev && redstone) {
            this.teleportAll();
        }
        this.master.redstoneActivePrev = redstone;
    }

    private boolean formNetwork() {
        ArrayList temp = Lists.newArrayList();
        if (this.isMaster()) {
            for (BlockCoord c : this.getSurroundingCoords()) {
                TileEntity te = c.getTileEntity((IBlockAccess)this.worldObj);
                if (!(te instanceof TileTelePad)) {
                    return false;
                }
                temp.add((TileTelePad)te);
            }
            for (TileTelePad te : temp) {
                te.master = this;
                te.inNetwork = true;
                te.updateBlock();
                te.updateNeighborTEs();
            }
            this.master = this;
            return true;
        }
        return false;
    }

    private void breakNetwork() {
        this.master = null;
        this.inNetwork = false;
        for (BlockCoord c : this.getSurroundingCoords()) {
            TileEntity te = c.getTileEntity((IBlockAccess)this.worldObj);
            if (!(te instanceof TileTelePad)) continue;
            TileTelePad telepad = (TileTelePad)te;
            telepad.master = null;
            telepad.inNetwork = false;
            telepad.updateBlock();
            telepad.updateNeighborTEs();
        }
    }

    private List<BlockCoord> getSurroundingCoords() {
        ArrayList ret = Lists.newArrayList();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                ret.add(new BlockCoord(this.xCoord + x, this.yCoord, this.zCoord + z));
            }
        }
        return ret;
    }

    private void updateNeighborTEs() {
        BlockCoord bc = new BlockCoord((TileEntity)this);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord neighbor = bc.getLocation(dir);
            Block block = neighbor.getBlock((IBlockAccess)this.worldObj);
            if (block instanceof BlockTelePad) continue;
            block.onNeighborChange((IBlockAccess)this.worldObj, neighbor.x, neighbor.y, neighbor.z, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public boolean shouldUpdate() {
        return true;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound root) {
        super.writeCustomNBT(root);
        this.energy.writeToNBT(root);
        this.target.writeToNBT(root);
        root.setInteger("targetDim", this.targetDim);
        root.setBoolean("redstoneActive", this.redstoneActivePrev);
    }

    @Override
    protected void readCustomNBT(NBTTagCompound root) {
        super.readCustomNBT(root);
        this.energy.readFromNBT(root);
        this.target = BlockCoord.readFromNBT((NBTTagCompound)root);
        this.targetDim = root.getInteger("targetDim");
        this.redstoneActivePrev = root.getBoolean("redstoneActive");
        this.autoUpdate = true;
    }

    @Override
    public Packet getDescriptionPacket() {
        S35PacketUpdateTileEntity pkt = (S35PacketUpdateTileEntity)super.getDescriptionPacket();
        return pkt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
    }

    public void invalidate() {
        super.invalidate();
        if (this.worldObj.isRemote) {
            this.stopPlayingSound();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.worldObj.isRemote) {
            this.stopPlayingSound();
        }
    }

    private void stopPlayingSound() {
        if (this.activeSound != null) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    public int getPowerScaled(int scale) {
        return (int)((float)this.getEnergyStored() / (float)this.getMaxEnergyStored() * (float)scale);
    }

    private int calculateTeleportPower() {
        if (this.worldObj.provider.dimensionId == this.targetDim) {
            int distance = new BlockCoord((TileEntity)this).getDist(this.target);
            double base = Math.log(0.005 * (double)distance + 1.0);
            this.maxPower = (int)(base * (double)Config.telepadPowerCoefficient);
            if (this.maxPower <= 0) {
                this.maxPower = 1;
            }
        } else {
            this.maxPower = Config.telepadPowerInterdimensional;
        }
        return this.maxPower;
    }

    public boolean active() {
        return !this.toTeleport.isEmpty();
    }

    public Entity getCurrentTarget() {
        return this.toTeleport.peek();
    }

    public AxisAlignedBB getBoundingBox() {
        if (!this.inNetwork()) {
            return AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1));
        }
        TileTelePad master = this.getMaster();
        return AxisAlignedBB.getBoundingBox((double)(master.xCoord - 1), (double)master.yCoord, (double)(master.zCoord - 1), (double)(master.xCoord + 2), (double)(master.yCoord + 1), (double)(master.zCoord + 2));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox();
    }

    public void updateRotations() {
        this.spinSpeed = this.active() ? this.getProgress() * 2.0f : Math.max(0.0f, this.spinSpeed - 0.025f);
        int i = 0;
        while (i < this.bladeRots.length) {
            int n = i;
            this.bladeRots[n] = this.bladeRots[n] + this.spinSpeed * (float)(i * 2 + 20);
            int n2 = i++;
            this.bladeRots[n2] = this.bladeRots[n2] % 360.0f;
        }
    }

    public float getProgress() {
        return (float)this.powerUsed / (float)this.maxPower;
    }

    protected int getProgressUpdateFreq() {
        return 1;
    }

    public void setProgress(float progress) {
        this.powerUsed = progress < 0.0f ? 0 : (int)((float)this.maxPower * progress);
    }

    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public boolean isMaster() {
        return this.connections.size() == 4;
    }

    @Override
    public TileTelePad getMaster() {
        return this.master;
    }

    @Override
    public boolean inNetwork() {
        return this.inNetwork;
    }

    @Override
    public int getX() {
        if (this.inNetwork()) {
            return this.master.target.x;
        }
        return this.target.x;
    }

    @Override
    public int getY() {
        if (this.inNetwork()) {
            return this.master.target.y;
        }
        return this.target.y;
    }

    @Override
    public int getZ() {
        if (this.inNetwork()) {
            return this.master.target.z;
        }
        return this.target.z;
    }

    @Override
    public int getTargetDim() {
        if (this.inNetwork()) {
            return this.master.targetDim;
        }
        return this.targetDim;
    }

    @Override
    public ITelePad setX(int x) {
        return Config.telepadLockCoords ? null : this.setX_internal(x);
    }

    @Override
    public ITelePad setY(int y) {
        return Config.telepadLockCoords ? null : this.setY_internal(y);
    }

    @Override
    public ITelePad setZ(int z) {
        return Config.telepadLockCoords ? null : this.setZ_internal(z);
    }

    @Override
    public ITelePad setTargetDim(int dimID) {
        return Config.telepadLockDimension ? null : this.setTargetDim_internal(dimID);
    }

    @Override
    public void setCoords(BlockCoord coords) {
        if (!Config.telepadLockCoords) {
            this.setCoords_internal(coords);
        }
    }

    ITelePad setX_internal(int x) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(x, this.target.y, this.target.z));
            return this.master;
        }
        return null;
    }

    ITelePad setY_internal(int y) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(this.target.x, y, this.target.z));
            return this.master;
        }
        return null;
    }

    ITelePad setZ_internal(int z) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(this.target.x, this.target.y, z));
            return this.master;
        }
        return null;
    }

    ITelePad setTargetDim_internal(int dimID) {
        if (this.inNetwork()) {
            this.master.targetDim = dimID;
            this.coordsChanged = true;
            return this.master;
        }
        return null;
    }

    void setCoords_internal(BlockCoord coords) {
        if (this.inNetwork()) {
            if (this.isMaster()) {
                this.target = coords;
                this.coordsChanged = true;
            } else {
                this.master.setCoords_internal(coords);
            }
        }
    }

    @Override
    public void teleportSpecific(Entity entity) {
        if (!this.inNetwork()) {
            return;
        }
        if (this.isMaster()) {
            if (this.isEntityInRange(entity)) {
                this.enqueueTeleport(entity, true);
            }
        } else {
            this.master.teleportSpecific(entity);
        }
    }

    @Override
    public void teleportAll() {
        if (!this.inNetwork()) {
            return;
        }
        if (this.isMaster()) {
            for (Entity e : this.getEntitiesInRange()) {
                this.enqueueTeleport(e, true);
            }
        } else {
            this.master.teleportAll();
        }
    }

    private List<Entity> getEntitiesInRange() {
        return this.worldObj.getEntitiesWithinAABB(Entity.class, this.getRange());
    }

    private boolean isEntityInRange(Entity entity) {
        return this.getRange().isVecInside(Vec3.createVectorHelper((double)entity.posX, (double)entity.posY, (double)entity.posZ));
    }

    private AxisAlignedBB getRange() {
        return AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)this.yCoord, (double)(this.zCoord - 1), (double)(this.xCoord + 2), (double)(this.yCoord + 3), (double)(this.zCoord + 2));
    }

    void enqueueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null || this.toTeleport.contains(entity)) {
            return;
        }
        this.calculateTeleportPower();
        entity.getEntityData().setBoolean(TELEPORTING_KEY, true);
        this.toTeleport.add(entity);
        if (sendUpdate) {
            if (entity.worldObj.isRemote) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, this, entity.getEntityId()));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, this, entity.getEntityId()));
            }
        }
    }

    void dequeueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null) {
            return;
        }
        this.toTeleport.remove(entity);
        entity.getEntityData().setBoolean(TELEPORTING_KEY, false);
        if (sendUpdate) {
            if (this.worldObj.isRemote) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleport(PacketTeleport.Type.END, this, entity.getEntityId()));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.END, this, entity.getEntityId()));
            }
        }
        if (!this.active()) {
            this.powerUsed = 0;
        }
    }

    private boolean teleport(Entity entity) {
        if (this.maxPower > 0) {
            entity.getEntityData().setBoolean(TELEPORTING_KEY, false);
            this.wasBlocked = !(!entity.worldObj.isRemote ? this.serverTeleport(entity) : this.clientTeleport(entity));
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.TELEPORT, this, this.wasBlocked));
            return !this.wasBlocked;
        }
        return false;
    }

    private boolean clientTeleport(Entity entity) {
        if (entity.worldObj.provider.dimensionId == this.targetDim) {
            return TravelController.instance.doClientTeleport(entity, this.target, TravelSource.TELEPAD, 0, false);
        }
        return true;
    }

    private boolean serverTeleport(Entity entity) {
        this.dequeueTeleport(entity, true);
        if (entity.worldObj.provider.dimensionId != this.targetDim) {
            MinecraftServer server = MinecraftServer.getServer();
            int currentDim = entity.worldObj.provider.dimensionId;
            if (entity instanceof EntityPlayer) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                server.getConfigurationManager().transferPlayerToDimension(player, this.targetDim, (Teleporter)new TeleporterEIO(server.worldServerForDimension(this.targetDim)));
            } else {
                WorldServer toDim = server.worldServerForDimension(this.targetDim);
                server.getConfigurationManager().transferEntityToWorld(entity, 0, server.worldServerForDimension(currentDim), toDim, (Teleporter)new TeleporterEIO(toDim));
            }
        }
        return PacketTravelEvent.doServerTeleport(entity, this.target.x, this.target.y, this.target.z, 0, false, TravelSource.TELEPAD);
    }

    @Override
    public boolean canSeeBlock(EntityPlayer playerName) {
        return this.isMaster() && this.inNetwork && this.getEnergyStored() > 0;
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        return this.inNetwork && this.master != null ? (this.master == this ? this.energy.getMaxReceive() : this.master.getMaxEnergyRecieved(dir)) : 0;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.inNetwork && this.master != null ? (this.master == this ? this.energy.getMaxEnergyStored() : this.master.getMaxEnergyStored()) : 0;
    }

    @Override
    public boolean displayPower() {
        return this.inNetwork && this.master != null;
    }

    @Override
    public int getEnergyStored() {
        return this.inNetwork && this.master != null ? (this.master == this ? this.energy.getEnergyStored() : this.master.getEnergyStored()) : 0;
    }

    @Override
    public void setEnergyStored(int storedEnergy) {
        if (this.inNetwork && this.master != null) {
            if (this.master == this) {
                this.energy.setEnergyStored(storedEnergy);
            } else {
                this.master.setEnergyStored(storedEnergy);
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.inNetwork && this.master != null;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.inNetwork && this.master != null ? (this.master == this ? this.energy.receiveEnergy(maxReceive, simulate) : this.master.receiveEnergy(from, maxReceive, simulate)) : 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.inNetwork && this.master != null ? (this.master == this ? this.energy.getEnergyStored() : this.master.getEnergyStored()) : 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.inNetwork && this.master != null ? (this.master == this ? this.energy.getMaxEnergyStored() : this.master.getMaxEnergyStored()) : 0;
    }

    public int getUsage() {
        return this.energy.getMaxReceive();
    }
}

