/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.client.render.TechneUtil;
import com.google.common.collect.Lists;
import crazypants.enderio.teleport.telepad.TelePadRenderer;
import crazypants.enderio.teleport.telepad.TileTelePad;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.GroupObject;
import org.lwjgl.opengl.GL11;

public class TelePadSpecialRenderer
extends TileEntitySpecialRenderer {
    private final GroupObject blade1;
    private final GroupObject blade2;
    private final GroupObject blade3;
    private final List<GroupObject> blades;
    private final GroupObject glass;
    private static Random rand = new Random();

    public TelePadSpecialRenderer(TelePadRenderer telePadRenderer) {
        this.blade1 = telePadRenderer.getFullModel().get("blade1");
        this.blade2 = telePadRenderer.getFullModel().get("blade2");
        this.blade3 = telePadRenderer.getFullModel().get("blade3");
        this.blades = Lists.newArrayList((Object[])new GroupObject[]{this.blade3, this.blade2, this.blade1});
        this.glass = telePadRenderer.getFullModel().get("glass");
    }

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float p_147500_8_) {
        TileTelePad tp = (TileTelePad)te;
        if (tp.isMaster() && tp.inNetwork()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.01), (double)(z + 0.5));
            Tessellator tes = Tessellator.instance;
            tes.setBrightness(0xF000F0);
            GL11.glDepthMask((boolean)true);
            rand.setSeed(te.xCoord + te.yCoord + te.zCoord);
            for (int i = 0; i < 3; ++i) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)(tp.bladeRots[i] + (float)rand.nextInt(360) + tp.spinSpeed * p_147500_8_ * (float)(i + 20)), (float)0.0f, (float)1.0f, (float)0.0f);
                this.render(this.blades.get(i), te, tes);
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)3042);
            this.render(this.glass, te, tes);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    private void render(GroupObject model, TileEntity te, Tessellator tes) {
        IIcon icon = te.getBlockType().getIcon((IBlockAccess)te.getWorldObj(), te.xCoord, te.yCoord, te.zCoord, 0);
        if (icon != null && model != null) {
            tes.startDrawingQuads();
            TechneUtil.renderWithIcon((GroupObject)model, (IIcon)icon, null, (Tessellator)Tessellator.instance, (IBlockAccess)te.getWorldObj(), (int)0, (int)0, (int)0, null, (boolean)false);
            tes.draw();
        }
    }
}

