/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.anchor;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4f;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.teleport.TravelController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class TravelEntitySpecialRenderer
extends TileEntitySpecialRenderer {
    private final Vector4f selectedColor;
    private final Vector4f highlightColor;
    private EntityItem ei;

    public TravelEntitySpecialRenderer() {
        this(new Vector4f(1.0f, 0.25f, 0.0f, 0.5f), new Vector4f(1.0f, 1.0f, 1.0f, 0.25f));
    }

    public TravelEntitySpecialRenderer(Vector4f selectedColor, Vector4f highlightColor) {
        this.selectedColor = selectedColor;
        this.highlightColor = highlightColor;
    }

    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f) {
        double maxDistance;
        if (!TravelController.instance.showTargets()) {
            return;
        }
        ITravelAccessable ta = (ITravelAccessable)tileentity;
        BlockCoord onBlock = TravelController.instance.onBlockCoord;
        if (onBlock != null && onBlock.equals((Object)ta.getLocation())) {
            return;
        }
        if (!ta.canSeeBlock((EntityPlayer)Minecraft.getMinecraft().thePlayer)) {
            return;
        }
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)Minecraft.getMinecraft().thePlayer);
        Vector3d loc = new Vector3d((double)tileentity.xCoord + 0.5, (double)tileentity.yCoord + 0.5, (double)tileentity.zCoord + 0.5);
        double d = maxDistance = TravelController.instance.isTravelItemActive((EntityPlayer)Minecraft.getMinecraft().thePlayer) ? (double)TravelSource.STAFF.maxDistanceTravelledSq : (double)TravelSource.BLOCK.maxDistanceTravelledSq;
        if (eye.distanceSquared(loc) > maxDistance) {
            return;
        }
        double sf = TravelController.instance.getScaleForCandidate(loc);
        BlockCoord bc = new BlockCoord(tileentity);
        TravelController.instance.addCandidate(bc);
        Minecraft.getMinecraft().entityRenderer.disableLightmap(0.0);
        RenderUtil.bindBlockTexture();
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        Tessellator.instance.startDrawingQuads();
        this.renderBlock(sf);
        Tessellator.instance.draw();
        Tessellator.instance.startDrawingQuads();
        Tessellator.instance.setBrightness(0xF000F0);
        if (TravelController.instance.isBlockSelected(bc)) {
            Tessellator.instance.setColorRGBA_F(this.selectedColor.x, this.selectedColor.y, this.selectedColor.z, this.selectedColor.w);
            CubeRenderer.render((BoundingBox)BoundingBox.UNIT_CUBE.scale(sf + 0.05, sf + 0.05, sf + 0.05), (IIcon)this.getSelectedIcon());
        } else {
            Tessellator.instance.setColorRGBA_F(this.highlightColor.x, this.highlightColor.y, this.highlightColor.z, this.highlightColor.w);
            CubeRenderer.render((BoundingBox)BoundingBox.UNIT_CUBE.scale(sf + 0.05, sf + 0.05, sf + 0.05), (IIcon)this.getHighlightIcon());
        }
        Tessellator.instance.draw();
        GL11.glPopMatrix();
        this.renderLabel(tileentity, x, y, z, ta, sf);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
        Minecraft.getMinecraft().entityRenderer.enableLightmap(0.0);
    }

    private void renderLabel(TileEntity tileentity, double x, double y, double z, ITravelAccessable ta, double sf) {
        String toRender;
        float globalScale = (float)sf;
        ItemStack itemLabel = ta.getItemLabel();
        if (itemLabel != null && itemLabel.getItem() != null) {
            boolean isBlock = itemLabel.getItem() instanceof ItemBlock;
            float alpha = 0.5f;
            GL11.glBlendFunc((int)770, (int)32769);
            float col = 0.5f;
            GL14.glBlendColor((float)col, (float)col, (float)col, (float)col);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            if (!isBlock && Minecraft.getMinecraft().gameSettings.fancyGraphics) {
                RenderUtil.rotateToPlayer();
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)globalScale, (float)globalScale, (float)globalScale);
            GL11.glPushMatrix();
            if (isBlock) {
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
            } else {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                if (this.ei == null) {
                    this.ei = new EntityItem(tileentity.getWorldObj(), x, y, z, itemLabel);
                } else {
                    this.ei.setEntityItemStack(itemLabel);
                }
                RenderUtil.render3DItem((EntityItem)this.ei, (boolean)false);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
        if ((toRender = ta.getLabel()) != null && toRender.trim().length() > 0) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Vector4f bgCol = RenderUtil.DEFAULT_TEXT_BG_COL;
            if (TravelController.instance.isBlockSelected(new BlockCoord(tileentity))) {
                bgCol = new Vector4f(this.selectedColor.x, this.selectedColor.y, this.selectedColor.z, this.selectedColor.w);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GL11.glPushMatrix();
            GL11.glScalef((float)globalScale, (float)globalScale, (float)globalScale);
            Vector3f pos = new Vector3f(0.0f, 1.2f, 0.0f);
            float size = 0.5f;
            RenderUtil.drawBillboardedText((Vector3f)pos, (String)toRender, (float)size, (Vector4f)bgCol);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    protected void renderBlock(double sf) {
        Tessellator.instance.setColorRGBA_F(1.0f, 1.0f, 1.0f, 0.75f);
        CubeRenderer.render((BoundingBox)BoundingBox.UNIT_CUBE.scale(sf, sf, sf), (IIcon)EnderIO.blockTravelPlatform.getIcon(0, 0));
    }

    public Vector4f getSelectedColor() {
        return this.selectedColor;
    }

    public IIcon getSelectedIcon() {
        return EnderIO.blockTravelPlatform.selectedOverlayIcon;
    }

    public Vector4f getHighlightColor() {
        return this.highlightColor;
    }

    public IIcon getHighlightIcon() {
        return EnderIO.blockTravelPlatform.highlightOverlayIcon;
    }
}

