/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.anchor;

import com.enderio.core.common.util.PlayerUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileTravelAnchor
extends TileEntityEio
implements ITravelAccessable,
IPaintableTileEntity {
    private static final String KEY_SOURCE_BLOCK_ID = "sourceBlock";
    private static final String KEY_SOURCE_BLOCK_META = "sourceBlockMeta";
    private Block sourceBlock;
    private int sourceBlockMetadata;
    private ITravelAccessable.AccessMode accessMode = ITravelAccessable.AccessMode.PUBLIC;
    private ItemStack[] password = new ItemStack[5];
    private ItemStack itemLabel;
    private String label;
    private UUID placedBy;
    private List<UUID> authorisedUsers = new ArrayList<UUID>();

    @Override
    public boolean canBlockBeAccessed(EntityPlayer playerName) {
        if (this.accessMode == ITravelAccessable.AccessMode.PUBLIC) {
            return true;
        }
        return this.placedBy != null && this.placedBy.equals(PlayerUtil.getPlayerUUID((String)playerName.getGameProfile().getName())) || this.authorisedUsers.contains(PlayerUtil.getPlayerUUID((String)playerName.getGameProfile().getName()));
    }

    @Override
    public void clearAuthorisedUsers() {
        this.authorisedUsers.clear();
    }

    private boolean checkPassword(ItemStack[] pwd) {
        if (pwd == null || pwd.length != this.password.length) {
            return false;
        }
        for (int i = 0; i < pwd.length; ++i) {
            ItemStack pw = this.password[i];
            ItemStack tst = pwd[i];
            if (pw == null && tst != null) {
                return false;
            }
            if (pw == null || tst != null && ItemStack.areItemStacksEqual((ItemStack)pw, (ItemStack)tst)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getRequiresPassword(EntityPlayer playerName) {
        return this.getAccessMode() == ITravelAccessable.AccessMode.PROTECTED && !this.canUiBeAccessed(playerName) && !this.authorisedUsers.contains(PlayerUtil.getPlayerUUID((String)playerName.getGameProfile().getName()));
    }

    @Override
    public boolean authoriseUser(EntityPlayer username, ItemStack[] password) {
        if (this.checkPassword(password)) {
            this.authorisedUsers.add(PlayerUtil.getPlayerUUID((String)username.getGameProfile().getName()));
            return true;
        }
        return false;
    }

    @Override
    public boolean canUiBeAccessed(EntityPlayer playerName) {
        return this.placedBy != null && this.placedBy.equals(PlayerUtil.getPlayerUUID((String)playerName.getGameProfile().getName()));
    }

    @Override
    public boolean canSeeBlock(EntityPlayer playerName) {
        if (this.accessMode != ITravelAccessable.AccessMode.PRIVATE) {
            return true;
        }
        return this.placedBy != null && this.placedBy.equals(PlayerUtil.getPlayerUUID((String)playerName.getGameProfile().getName()));
    }

    @Override
    public ITravelAccessable.AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public void setAccessMode(ITravelAccessable.AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public ItemStack[] getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(ItemStack[] password) {
        this.password = password;
    }

    @Override
    public ItemStack getItemLabel() {
        return this.itemLabel;
    }

    @Override
    public void setItemLabel(ItemStack lableIcon) {
        this.itemLabel = lableIcon;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public UUID getPlacedBy() {
        return this.placedBy;
    }

    @Override
    public void setPlacedBy(EntityPlayer player) {
        this.placedBy = player == null || player.getGameProfile() == null ? null : PlayerUtil.getPlayerUUID((String)player.getGameProfile().getName());
    }

    public boolean shouldUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return TravelSource.getMaxDistanceSq();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public Block getSourceBlock() {
        return this.sourceBlock;
    }

    @Override
    public void setSourceBlock(Block sourceBlock) {
        this.sourceBlock = sourceBlock;
    }

    @Override
    public int getSourceBlockMetadata() {
        return this.sourceBlockMetadata;
    }

    @Override
    public void setSourceBlockMetadata(int sourceBlockMetadata) {
        this.sourceBlockMetadata = sourceBlockMetadata;
    }

    protected void readCustomNBT(NBTTagCompound root) {
        NBTTagCompound stackRoot;
        this.accessMode = root.hasKey("accessMode") ? ITravelAccessable.AccessMode.values()[root.getShort("accessMode")] : ITravelAccessable.AccessMode.PUBLIC;
        this.placedBy = PlayerUtil.getPlayerUIDUnstable((String)root.getString("placedBy"));
        for (int i = 0; i < this.password.length; ++i) {
            if (root.hasKey("password" + i)) {
                stackRoot = (NBTTagCompound)root.getTag("password" + i);
                this.password[i] = ItemStack.loadItemStackFromNBT((NBTTagCompound)stackRoot);
                continue;
            }
            this.password[i] = null;
        }
        this.authorisedUsers.clear();
        String userStr = root.getString("authorisedUsers");
        if (userStr != null && userStr.length() > 0) {
            String[] users;
            for (String user : users = userStr.split(",")) {
                if (user == null || (user = user.trim()).length() <= 0) continue;
                this.authorisedUsers.add(PlayerUtil.getPlayerUIDUnstable((String)user));
            }
        }
        if (root.hasKey("itemLabel")) {
            stackRoot = (NBTTagCompound)root.getTag("itemLabel");
            this.itemLabel = ItemStack.loadItemStackFromNBT((NBTTagCompound)stackRoot);
        } else {
            this.itemLabel = null;
        }
        String sourceBlockStr = root.getString(KEY_SOURCE_BLOCK_ID);
        this.sourceBlock = Block.getBlockFromName((String)sourceBlockStr);
        this.sourceBlockMetadata = root.getInteger(KEY_SOURCE_BLOCK_META);
        this.label = root.getString("label");
        if (this.label == null || this.label.trim().length() == 0) {
            this.label = null;
        }
    }

    protected void writeCustomNBT(NBTTagCompound root) {
        root.setShort("accessMode", (short)this.accessMode.ordinal());
        if (this.placedBy != null) {
            root.setString("placedBy", this.placedBy.toString());
        }
        for (int i = 0; i < this.password.length; ++i) {
            ItemStack stack = this.password[i];
            if (stack == null) continue;
            NBTTagCompound stackRoot = new NBTTagCompound();
            stack.writeToNBT(stackRoot);
            root.setTag("password" + i, (NBTBase)stackRoot);
        }
        StringBuffer userStr = new StringBuffer();
        for (UUID user : this.authorisedUsers) {
            if (user == null) continue;
            userStr.append(user.toString());
            userStr.append(",");
        }
        if (this.authorisedUsers.size() > 0) {
            root.setString("authorisedUsers", userStr.toString());
        }
        if (this.itemLabel != null) {
            NBTTagCompound labelRoot = new NBTTagCompound();
            this.itemLabel.writeToNBT(labelRoot);
            root.setTag("itemLabel", (NBTBase)labelRoot);
        }
        if (this.sourceBlock != null) {
            root.setString(KEY_SOURCE_BLOCK_ID, Block.blockRegistry.getNameForObject((Object)this.sourceBlock));
        }
        root.setInteger(KEY_SOURCE_BLOCK_META, this.sourceBlockMetadata);
        if (this.label != null && this.label.trim().length() > 0) {
            root.setString("label", this.label);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }
}

