/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import cofh.api.energy.ItemEnergyContainer;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.teleport.TravelController;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemTravelStaff
extends ItemEnergyContainer
implements IItemOfTravel,
IResourceTooltipProvider {
    private long lastBlickTick = 0L;

    public static boolean isEquipped(EntityPlayer ep) {
        if (ep == null || ep.getCurrentEquippedItem() == null) {
            return false;
        }
        return ep.getCurrentEquippedItem().getItem() == EnderIO.itemTravelStaff;
    }

    public static ItemTravelStaff create() {
        ItemTravelStaff result = new ItemTravelStaff();
        result.init();
        return result;
    }

    protected ItemTravelStaff() {
        super(Config.darkSteelPowerStorageLevelTwo, Config.darkSteelPowerStorageLevelTwo / 100, 0);
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemTravelStaff.name());
        this.setMaxDamage(16);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemTravelStaff.unlocalisedName);
    }

    public void onCreated(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergy(itemStack, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister IIconRegister2) {
        this.itemIcon = IIconRegister2.registerIcon("enderio:itemTravelStaff");
    }

    public ItemStack onItemRightClick(ItemStack equipped, World world, EntityPlayer player) {
        if (player.isSneaking()) {
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.isRemote && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(equipped, player)) {
                player.swingItem();
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return equipped;
        }
        if (world.isRemote) {
            TravelController.instance.activateTravelAccessable(equipped, world, player, TravelSource.STAFF);
        }
        player.swingItem();
        return equipped;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, par2EntityPlayer, list, par4);
        String str = PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(this.getMaxEnergyStored(itemStack)) + " " + PowerDisplayUtil.abrevation();
        list.add(str);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int res = super.receiveEnergy(container, maxReceive, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int res = super.extractEnergy(container, maxExtract, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    @Override
    public void extractInternal(ItemStack item, int powerUse) {
        int res = Math.max(0, this.getEnergyStored(item) - powerUse);
        this.setEnergy(item, res);
    }

    void setEnergy(ItemStack container, int energy) {
        if (container.stackTagCompound == null) {
            container.stackTagCompound = new NBTTagCompound();
        }
        container.stackTagCompound.setInteger("Energy", energy);
        this.updateDamage(container);
    }

    public void setFull(ItemStack container) {
        this.setEnergy(container, Config.darkSteelPowerStorageLevelTwo);
    }

    private void updateDamage(ItemStack stack) {
        float r = (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack);
        int res = 16 - (int)(r * 16.0f);
        stack.setItemDamage(res);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        this.setFull(is);
        par3List.add(is);
        is = new ItemStack((Item)this);
        this.setEnergy(is, 0);
        par3List.add(is);
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.getUnlocalizedName();
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return ItemTravelStaff.isEquipped(ep);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }
}

