/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.network.MessageTileNBT;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.ContainerTravelAuth;
import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiTravelAuth
extends GuiContainerBase {
    private final String title;
    private final ITravelAccessable ta;
    private boolean failed = false;
    private final EntityPlayer player;

    public GuiTravelAuth(EntityPlayer player, ITravelAccessable te, World world) {
        super((Container)new ContainerTravelAuth(player.inventory));
        this.ta = te;
        this.title = EnderIO.lang.localize("gui.travelAccessable.enterCode");
        this.player = player;
    }

    public void initGui() {
        super.initGui();
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        String str = EnderIO.lang.localize("gui.travelAccessable.ok");
        int strLen = this.getFontRenderer().getStringWidth(str);
        GuiButton okB = new GuiButton(0, this.width / 2 - strLen / 2 - 5, sy + 50, strLen + 10, 20, str);
        this.buttonList.clear();
        this.buttonList.add(okB);
    }

    protected void actionPerformed(GuiButton par1GuiButton) {
        ContainerTravelAuth poo = (ContainerTravelAuth)this.inventorySlots;
        if (this.ta.authoriseUser(this.player, ((ContainerTravelAuth.AuthInventory)poo.getInv()).getInventory())) {
            TileEntity te = (TileEntity)this.ta;
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTileNBT(te));
            this.mc.displayGuiScreen((GuiScreen)null);
            this.mc.setIngameFocus();
        } else {
            this.failed = true;
            poo.dirty = false;
        }
    }

    public void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/travelAuth.png");
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        int sw = this.getFontRenderer().getStringWidth(this.title);
        this.getFontRenderer().drawString(this.title, this.width / 2 - sw / 2, sy + 12, ColorUtil.getRGB((Color)Color.red));
        ContainerTravelAuth poo = (ContainerTravelAuth)this.inventorySlots;
        if (poo.dirty) {
            poo.dirty = false;
            this.failed = false;
        }
        if (this.failed) {
            GuiTravelAuth.drawRect((int)(sx + 43), (int)(sy + 27), (int)(sx + 43 + 90), (int)(sy + 27 + 18), (int)ColorUtil.getARGB((Color)new Color(1.0f, 0.0f, 0.0f, 0.5f)));
        }
    }
}

