/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.client.gui.widget.TemplateSlot;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.ArrayInventory;
import crazypants.enderio.api.teleport.ITravelAccessable;
import java.awt.Point;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ContainerTravelAccessable
extends ContainerEnder<PasswordInventory> {
    ITravelAccessable ta;
    TileEntity te;
    World world;

    public ContainerTravelAccessable(InventoryPlayer playerInv, ITravelAccessable travelAccessable, World world) {
        super(playerInv, (IInventory)new PasswordInventory(travelAccessable, world, true));
        this.ta = travelAccessable;
        this.world = world;
        if (this.ta instanceof TileEntity) {
            this.te = (TileEntity)this.ta;
        }
        ((PasswordInventory)this.getInv()).te = this.te;
    }

    protected void addSlots(InventoryPlayer playerInv) {
        int x = 44;
        int y = 73;
        for (int i = 0; i < 5; ++i) {
            this.addSlotToContainer((Slot)new TemplateSlot(this.getInv(), i, x, y));
            x += 18;
        }
        PasswordInventory arrInv = new PasswordInventory(((PasswordInventory)this.getInv()).ta, ((PasswordInventory)this.getInv()).world, false);
        x = 125;
        y = 10;
        this.addSlotToContainer((Slot)new TemplateSlot((IInventory)arrInv, 0, x, y));
    }

    public Point getPlayerInventoryOffset() {
        return new Point(8, 103);
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        return null;
    }

    static class PasswordInventory
    extends ArrayInventory {
        boolean isAuth;
        World world;
        TileEntity te;
        ITravelAccessable ta;

        public PasswordInventory(ITravelAccessable ta, World world, boolean isAuth) {
            ItemStack[] itemStackArray;
            if (isAuth) {
                itemStackArray = ta.getPassword();
            } else {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = ta.getItemLabel();
            }
            super(itemStackArray);
            this.isAuth = isAuth;
            this.world = world;
            if (ta instanceof TileEntity) {
                this.te = (TileEntity)ta;
            }
            this.ta = ta;
        }

        public void markDirty() {
            super.markDirty();
            if (!this.world.isRemote && this.te != null) {
                if (this.isAuth) {
                    ((ITravelAccessable)this.te).clearAuthorisedUsers();
                }
                this.world.markBlockForUpdate(this.te.xCoord, this.te.yCoord, this.te.zCoord);
            }
        }

        public int getSizeInventory() {
            return this.items.length;
        }

        public ItemStack getStackInSlot(int i) {
            if (i < 0 || i >= this.items.length) {
                return null;
            }
            return this.items[i];
        }

        public ItemStack decrStackSize(int fromSlot, int amount) {
            ItemStack item = this.items[fromSlot];
            this.items[fromSlot] = null;
            if (item == null) {
                return null;
            }
            item.stackSize = 0;
            return item;
        }

        public ItemStack getStackInSlotOnClosing(int i) {
            return null;
        }

        public void setInventorySlotContents(int i, ItemStack itemstack) {
            if (itemstack != null) {
                this.items[i] = itemstack.copy();
                this.items[i].stackSize = 0;
            } else {
                this.items[i] = null;
            }
            ((ITravelAccessable)this.te).setItemLabel(this.items[i]);
        }

        public String getInventoryName() {
            return "Password";
        }

        public int getInventoryStackLimit() {
            return 0;
        }
    }
}

