/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.rail;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.rail.PacketTeleportEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TeleportUtil {
    public static List<Entity> createEntitiesForReciever(EntityMinecart cart, TileTransceiver sender, TileTransceiver reciever) {
        int toDimension = reciever.getWorldObj().provider.dimensionId;
        int toX = reciever.xCoord;
        int toY = reciever.yCoord + 1;
        int toZ = reciever.zCoord;
        MinecraftServer minecraftserver = MinecraftServer.getServer();
        WorldServer worldserver1 = minecraftserver.worldServerForDimension(toDimension);
        EntityMinecart newCart = (EntityMinecart)EntityList.createEntityByName((String)EntityList.getEntityString((Entity)cart), (World)worldserver1);
        if (newCart == null) {
            return null;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        cart.writeToNBT(nbttagcompound);
        newCart.readFromNBT(nbttagcompound);
        newCart.dimension = toDimension;
        newCart.setLocationAndAngles((double)toX + 0.5, (double)toY, (double)toZ + 0.5, cart.rotationYaw, cart.rotationPitch);
        newCart.isDead = false;
        ArrayList<Entity> result = new ArrayList<Entity>();
        result.add((Entity)newCart);
        Entity passenger = cart.riddenByEntity;
        if (passenger != null && !(passenger instanceof EntityPlayer)) {
            Entity newPas = EntityList.createEntityByName((String)EntityList.getEntityString((Entity)passenger), (World)worldserver1);
            newPas.copyDataFrom(passenger, true);
            newPas.dimension = toDimension;
            newPas.setLocationAndAngles((double)toX + 0.5, (double)toY, (double)toZ + 0.5, cart.rotationYaw, cart.rotationPitch);
            newCart.riddenByEntity = newPas;
            newPas.ridingEntity = newCart;
            result.add(newPas);
        }
        return result;
    }

    public static void despawn(World world, EntityMinecart cart) {
        if (cart instanceof IInventory) {
            IInventory cont = (IInventory)cart;
            for (int i = 0; i < cont.getSizeInventory(); ++i) {
                cont.setInventorySlotContents(i, null);
            }
        }
        MinecraftServer minecraftserver = MinecraftServer.getServer();
        WorldServer worldserver = minecraftserver.worldServerForDimension(world.provider.dimensionId);
        Entity passenger = cart.riddenByEntity;
        if (passenger != null && !(passenger instanceof EntityPlayer)) {
            worldserver.removeEntity(passenger);
            passenger.isDead = true;
        }
        worldserver.removeEntity((Entity)cart);
        cart.isDead = true;
    }

    public static void spawn(World world, Entity entity) {
        if (entity != null) {
            MinecraftServer minecraftserver = MinecraftServer.getServer();
            WorldServer worldserver = minecraftserver.worldServerForDimension(world.provider.dimensionId);
            worldserver.spawnEntityInWorld(entity);
        }
    }

    public static void spawnTeleportEffects(World world, Entity entity) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketTeleportEffects(entity), new NetworkRegistry.TargetPoint(world.provider.dimensionId, entity.posX, entity.posY, entity.posZ, 64.0));
        if (Config.machineSoundsEnabled) {
            world.playSoundEffect(entity.posX, entity.posY, entity.posZ, "mob.endermen.portal", 0.5f, 0.25f);
        }
    }
}

