/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.rail;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.rail.BlockEnderRail;
import crazypants.enderio.rail.CartLinkUtil;
import crazypants.enderio.rail.TeleportUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class EnderRailController {
    private final Set<UUID> newlySpawnedCarts = new HashSet<UUID>();
    private final LinkedList<List<Entity>> cartsToSpawn = new LinkedList();
    private final List<PlayerTpInfo> playersToRemount = new ArrayList<PlayerTpInfo>();
    private int ticksFailedToSpawn = 0;
    private NBTTagList cartList;
    private final TileTransceiver transciever;

    public EnderRailController(TileTransceiver tileTransceiver) {
        this.transciever = tileTransceiver;
    }

    public void doTick() {
        if (this.cartList != null) {
            this.loadCartsToSpawn();
            this.cartList = null;
        }
        this.spawnRecievedCart();
        List<EntityMinecart> carts = this.getMinecartsOnTrack();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (UUID recievedCartUID : this.newlySpawnedCarts) {
            EntityMinecart minecart = this.getMinecartWthUUID(recievedCartUID, carts);
            if (minecart != null) continue;
            toRemove.add(recievedCartUID);
        }
        for (UUID recievedCart : toRemove) {
            this.newlySpawnedCarts.remove(recievedCart);
        }
    }

    private EntityMinecart getMinecartWthUUID(UUID recievedCartUID, Collection<EntityMinecart> carts) {
        for (EntityMinecart cart : carts) {
            if (!recievedCartUID.equals(cart.getPersistentID())) continue;
            return cart;
        }
        return null;
    }

    private void spawnRecievedCart() {
        if (Config.enderRailTeleportPlayers) {
            ListIterator<PlayerTpInfo> li = this.playersToRemount.listIterator();
            while (li.hasNext()) {
                PlayerTpInfo tpi = li.next();
                if (!tpi.attemptMount() && tpi.attemptsRemaining > 0) continue;
                li.remove();
            }
        }
        if (this.cartsToSpawn.isEmpty()) {
            this.ticksFailedToSpawn = 0;
            return;
        }
        boolean failedSpawn = false;
        if (!this.isClear()) {
            ++this.ticksFailedToSpawn;
            if (this.ticksFailedToSpawn < Config.enderRailTicksBeforeForceSpawningLinkedCarts) {
                return;
            }
            failedSpawn = true;
        }
        List<Entity> spawnThisTick = this.cartsToSpawn.removeFirst();
        for (Entity ent : spawnThisTick) {
            if (failedSpawn) {
                this.doRandomSpawn(ent);
                continue;
            }
            EntityMinecart cart = null;
            if (ent instanceof EntityMinecart) {
                cart = (EntityMinecart)ent;
                this.setCartDirection(cart);
            }
            TeleportUtil.spawn(this.transciever.getWorldObj(), ent);
            if (cart == null) continue;
            this.newlySpawnedCarts.add(cart.getPersistentID());
            CartLinkUtil.instance.recreateLinks(cart);
        }
        this.ticksFailedToSpawn = 0;
    }

    private void setCartDirection(EntityMinecart cart) {
        int meta = this.transciever.getWorldObj().getBlockMetadata(this.transciever.xCoord, this.transciever.yCoord + 1, this.transciever.zCoord);
        ForgeDirection dir = BlockEnderRail.getDirection(meta);
        CartLinkUtil.instance.setCartDirection(cart, dir);
    }

    public void onTrainRecieved(List<List<Entity>> toTeleport) {
        this.cartsToSpawn.addAll(toTeleport);
    }

    public boolean isRecievedCart(EntityMinecart mc) {
        return this.newlySpawnedCarts.contains(mc.getPersistentID());
    }

    public boolean isClear() {
        World worldObj = this.transciever.getWorldObj();
        BlockCoord railCoord = new BlockCoord((TileEntity)this.transciever).getLocation(ForgeDirection.UP);
        int meta = worldObj.getBlockMetadata(railCoord.x, railCoord.y, railCoord.z);
        double buf = 1.0;
        ForgeDirection dir = BlockEnderRail.getDirection(meta);
        Vector3d offset = ForgeDirectionOffsets.forDirCopy((ForgeDirection)dir);
        offset.scale(buf);
        offset.x = Math.abs(offset.x);
        offset.z = Math.abs(offset.z);
        List res = worldObj.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBox((double)((double)railCoord.x - offset.x), (double)railCoord.y, (double)((double)railCoord.z - offset.z), (double)((double)(railCoord.x + 1) + offset.x), (double)(railCoord.y + 1), (double)((double)(railCoord.z + 1) + offset.z)));
        return res == null || res.isEmpty();
    }

    public List<EntityMinecart> getMinecartsOnTrack() {
        return EnderRailController.getMinecartsAt(this.transciever.getWorldObj(), this.transciever.xCoord, this.transciever.yCoord + 1, this.transciever.zCoord);
    }

    public static List<EntityMinecart> getMinecartsAt(World world, int x, int y, int z) {
        List entities = world.getEntitiesWithinAABB(EntityMinecart.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (Object o : entities) {
            EntityMinecart cart = (EntityMinecart)o;
            if (cart.isDead) continue;
            carts.add((EntityMinecart)o);
        }
        return carts;
    }

    private void loadCartsToSpawn() {
        World worldObj = this.transciever.getWorldObj();
        while (this.cartList.tagCount() > 0) {
            NBTTagList entityList = (NBTTagList)this.cartList.removeTag(0);
            ArrayList<Entity> ents = new ArrayList<Entity>(entityList.tagCount());
            for (int i = 0; i < entityList.tagCount(); ++i) {
                NBTTagCompound entityRoot = entityList.getCompoundTagAt(i);
                Entity entity = EntityList.createEntityFromNBT((NBTTagCompound)entityRoot, (World)worldObj);
                if (entity == null) continue;
                ents.add(entity);
            }
            this.cartsToSpawn.add(ents);
        }
    }

    public void readFromNBT(NBTTagCompound root) {
        this.cartsToSpawn.clear();
        if (!root.hasKey("cartList")) {
            return;
        }
        this.cartList = (NBTTagList)root.getTag("cartList");
        this.newlySpawnedCarts.clear();
        if (root.hasKey("newlySpawnedCarts")) {
            NBTTagList spawnedCartList = (NBTTagList)root.getTag("newlySpawnedCarts");
            for (int i = 0; i < spawnedCartList.tagCount(); ++i) {
                String uuisStr = spawnedCartList.getStringTagAt(i);
                this.newlySpawnedCarts.add(UUID.fromString(uuisStr));
            }
        }
    }

    public void writeToNBT(NBTTagCompound root) {
        if (this.cartsToSpawn.isEmpty()) {
            return;
        }
        NBTTagList cartList = new NBTTagList();
        for (List list : this.cartsToSpawn) {
            if (list == null || list.isEmpty()) continue;
            NBTTagList entityList = new NBTTagList();
            cartList.appendTag((NBTBase)entityList);
            for (Entity entity : list) {
                NBTTagCompound entRoot = new NBTTagCompound();
                entRoot.setString("id", EntityList.getEntityString((Entity)entity));
                entity.writeToNBT(entRoot);
                entityList.appendTag((NBTBase)entRoot);
            }
        }
        root.setTag("cartList", (NBTBase)cartList);
        if (!this.newlySpawnedCarts.isEmpty()) {
            NBTTagList spawnedCartList = new NBTTagList();
            for (UUID uuid : this.newlySpawnedCarts) {
                spawnedCartList.appendTag((NBTBase)new NBTTagString(uuid.toString()));
            }
            root.setTag("newlySpawnedCarts", (NBTBase)spawnedCartList);
        }
    }

    public void dropNonSpawnedCarts() {
        if (this.cartsToSpawn.isEmpty()) {
            return;
        }
        for (List list : this.cartsToSpawn) {
            for (Entity entity : list) {
                this.doRandomSpawn(entity);
            }
        }
        this.cartsToSpawn.clear();
    }

    private void doRandomSpawn(Entity entity) {
        if (entity == null) {
            return;
        }
        double oX = entity.posX;
        double oZ = entity.posZ;
        World world = this.transciever.getWorldObj();
        MinecraftServer minecraftserver = MinecraftServer.getServer();
        WorldServer worldserver = minecraftserver.worldServerForDimension(world.provider.dimensionId);
        for (int i = 0; i < 4; ++i) {
            int x = this.transciever.xCoord + this.randOffset(2);
            int y = this.transciever.yCoord + 1;
            int z = this.transciever.zCoord + this.randOffset(2);
            Block b = world.getBlock(x, y, z);
            entity.setPosition((double)x + 0.5, entity.posY, (double)z + 0.5);
            if (!world.canPlaceEntityOnSide(b, x, y, z, false, ForgeDirection.UP.ordinal(), entity, null)) continue;
            this.resetForRandomRandomSpawn(entity);
            if (!worldserver.spawnEntityInWorld(entity)) continue;
            worldserver.updateEntity(entity);
            return;
        }
        entity.setPosition(oX, entity.posY, oZ);
        this.resetForRandomRandomSpawn(entity);
        worldserver.spawnEntityInWorld(entity);
    }

    private void resetForRandomRandomSpawn(Entity entity) {
        CartLinkUtil.instance.breakLinks(this.transciever.getWorldObj(), entity);
        entity.riddenByEntity = null;
        entity.ridingEntity = null;
        entity.motionX = 0.0;
        entity.motionY = 0.0;
        entity.motionZ = 0.0;
        entity.prevPosX = entity.posX;
        entity.prevPosY = entity.posY;
        entity.prevPosZ = entity.posZ;
        entity.rotationYaw = (float)(this.transciever.getWorldObj().rand.nextDouble() * 360.0);
    }

    private int randOffset(int spread) {
        return (int)Math.round((this.transciever.getWorldObj().rand.nextDouble() - 0.5) * (double)spread * 2.0);
    }

    public void onPlayerTeleported(EntityPlayerMP playerToTP, EntityMinecart toMount) {
        if (playerToTP != null) {
            this.playersToRemount.add(new PlayerTpInfo(playerToTP.getCommandSenderName(), toMount.getPersistentID(), 20));
        }
    }

    private class PlayerTpInfo {
        String playerName;
        UUID cartId;
        int attemptsRemaining;

        PlayerTpInfo(String playerName, UUID cartId, int attemptsRemaining) {
            this.playerName = playerName;
            this.cartId = cartId;
            this.attemptsRemaining = attemptsRemaining;
        }

        boolean attemptMount() {
            --this.attemptsRemaining;
            List<EntityMinecart> carts = EnderRailController.this.getMinecartsOnTrack();
            for (EntityMinecart cart : carts) {
                Vector3d cartPos;
                Vector3d playerPos;
                EntityPlayer player;
                if (cart == null || !cart.getPersistentID().equals(this.cartId) || (player = EnderRailController.this.transciever.getWorldObj().getPlayerEntityByName(this.playerName)) == null || !((playerPos = EntityUtil.getEntityPosition((Entity)player)).distanceSquared(cartPos = EntityUtil.getEntityPosition((Entity)cart)) <= 9.0)) continue;
                player.posX = cart.posX;
                player.posY = cart.posY;
                player.posZ = cart.posZ;
                player.mountEntity((Entity)cart);
                return true;
            }
            return false;
        }
    }
}

