/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.EnderWidget;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.alloy.AlloyRecipeManager;
import crazypants.enderio.machine.alloy.GuiAlloySmelter;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.recipe.IManyToOneRecipe;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class AlloySmelterRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"enderio.nei.alloysmelter");
    }

    public String getGuiTexture() {
        return "enderio:textures/gui/nei/alloySmelter.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiAlloySmelter.class;
    }

    public String getOverlayIdentifier() {
        return "EnderIOAlloySmelter";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(149, 32, 16, 16), "EnderIOAlloySmelter", new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null) {
            return;
        }
        ArrayList<IManyToOneRecipe> recipes = new ArrayList<IManyToOneRecipe>(AlloyRecipeManager.getInstance().getRecipes());
        recipes.addAll(AlloyRecipeManager.getInstance().getVanillaRecipe().getAllRecipes());
        for (IRecipe iRecipe : recipes) {
            ItemStack output = iRecipe.getOutputs()[0].getOutput();
            if (result.getItem() != output.getItem() || result.getItemDamage() != output.getItemDamage()) continue;
            AlloySmelterRecipe res = new AlloySmelterRecipe(iRecipe.getEnergyRequired(), iRecipe.getInputs(), output);
            this.arecipes.add(res);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("EnderIOAlloySmelter") && ((Object)((Object)this)).getClass() == AlloySmelterRecipeHandler.class) {
            ArrayList<IManyToOneRecipe> recipes = new ArrayList<IManyToOneRecipe>(AlloyRecipeManager.getInstance().getRecipes());
            recipes.addAll(AlloyRecipeManager.getInstance().getVanillaRecipe().getAllRecipes());
            for (IRecipe iRecipe : recipes) {
                ItemStack output = iRecipe.getOutputs()[0].getOutput();
                AlloySmelterRecipe res = new AlloySmelterRecipe(iRecipe.getEnergyRequired(), iRecipe.getInputs(), output);
                this.arecipes.add(res);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<IManyToOneRecipe> recipes = new ArrayList<IManyToOneRecipe>(AlloyRecipeManager.getInstance().getRecipes());
        recipes.addAll(AlloyRecipeManager.getInstance().getVanillaRecipe().getAllRecipes());
        for (IRecipe iRecipe : recipes) {
            if (!iRecipe.isValidInput(0, ingredient)) continue;
            ItemStack output = iRecipe.getOutputs()[0].getOutput();
            AlloySmelterRecipe res = new AlloySmelterRecipe(iRecipe.getEnergyRequired(), iRecipe.getInputs(), output);
            res.setIngredientPermutation(res.input, ingredient);
            this.arecipes.add(res);
        }
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)65);
    }

    public void drawExtras(int recipeIndex) {
        this.drawProgressBar(51, 31, 166, 0, 22, 13, 48, 3);
        this.drawProgressBar(99, 31, 166, 0, 22, 13, 48, 3);
        AlloySmelterRecipe recipe = (AlloySmelterRecipe)((Object)this.arecipes.get(recipeIndex));
        String energyString = PowerDisplayUtil.formatPower(recipe.getEnergy()) + " " + PowerDisplayUtil.abrevation();
        GuiDraw.drawString((String)energyString, (int)100, (int)52, (int)0x808080, (boolean)false);
        int x = 149;
        int y = 32;
        EnderWidget.map.render((IWidgetIcon)EnderWidget.BUTTON, (double)x, (double)y, 16.0, 16.0, 0.0, true);
        IconEIO.map.render((IWidgetIcon)IconEIO.RECIPE, (double)(x + 1), (double)(y + 1), 14.0, 14.0, 0.0, true);
    }

    public List<ItemStack> getInputs(RecipeInput input) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(input.getInput());
        ItemStack[] equivs = input.getEquivelentInputs();
        if (equivs != null) {
            for (ItemStack st : equivs) {
                result.add(st);
            }
        }
        return result;
    }

    public class AlloySmelterRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ArrayList<PositionedStack> input;
        private PositionedStack output;
        private int energy;

        public int getEnergy() {
            return this.energy;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AlloySmelterRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public AlloySmelterRecipe(int energy, RecipeInput[] ingredients, ItemStack result) {
            super((TemplateRecipeHandler)AlloySmelterRecipeHandler.this);
            int recipeSize = ingredients.length;
            this.input = new ArrayList();
            if (recipeSize > 0) {
                this.input.add(new PositionedStack(AlloySmelterRecipeHandler.this.getInputs(ingredients[0]), 50, 13));
            }
            if (recipeSize > 1) {
                this.input.add(new PositionedStack(AlloySmelterRecipeHandler.this.getInputs(ingredients[1]), 75, 3));
            }
            if (recipeSize > 2) {
                this.input.add(new PositionedStack(AlloySmelterRecipeHandler.this.getInputs(ingredients[2]), 99, 13));
            }
            if (result != null) {
                this.output = new PositionedStack((Object)result, 75, 42);
            }
            this.energy = energy;
        }
    }
}

