/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.ICapacitorItem;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;

public class ItemCapacitor
extends Item
implements ICapacitorItem {
    private static final BasicCapacitor CAP = new BasicCapacitor();
    private final IIcon[] icons;

    public static ItemCapacitor create() {
        ItemCapacitor result = new ItemCapacitor();
        result.init();
        return result;
    }

    protected ItemCapacitor() {
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setUnlocalizedName(ModObject.itemBasicCapacitor.unlocalisedName);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setMaxStackSize(64);
        this.icons = new IIcon[Capacitors.values().length];
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemBasicCapacitor.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        damage = MathHelper.clamp_int((int)damage, (int)0, (int)(Capacitors.values().length - 1));
        return this.icons[damage];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister IIconRegister2) {
        for (int i = 0; i < Capacitors.values().length; ++i) {
            this.icons[i] = IIconRegister2.registerIcon(Capacitors.values()[i].iconKey);
        }
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        int i = MathHelper.clamp_int((int)par1ItemStack.getItemDamage(), (int)0, (int)(Capacitors.values().length - 1));
        return Capacitors.values()[i].unlocalisedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < Capacitors.values().length; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    @Override
    public ICapacitor getCapacitor(ItemStack stack) {
        int damage = MathHelper.clamp_int((int)stack.getItemDamage(), (int)0, (int)(Capacitors.values().length - 1));
        return Capacitors.values()[damage].capacitor;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack != null && par1ItemStack.getItemDamage() > 0) {
            par3List.add(EnderIO.lang.localize("machine.tooltip.upgrade"));
            if (SpecialTooltipHandler.showAdvancedTooltips()) {
                SpecialTooltipHandler.addDetailedTooltipFromResources((List)par3List, (String)"enderio.machine.tooltip.upgrade");
            } else {
                SpecialTooltipHandler.addShowDetailsTooltip((List)par3List);
            }
        }
    }
}

