/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.material.BlockItemIngotStorage;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockIngotStorage
extends BlockEio
implements IAdvancedTooltipProvider {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public static BlockIngotStorage create() {
        BlockIngotStorage res = new BlockIngotStorage();
        res.init();
        return res;
    }

    private BlockIngotStorage() {
        super(ModObject.blockIngotStorage.unlocalisedName, null, Material.iron);
        this.setStepSound(soundTypeMetal);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemIngotStorage.class, (String)ModObject.blockIngotStorage.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.icons = new IIcon[Alloy.values().length];
        for (Alloy alloy : Alloy.values()) {
            this.icons[alloy.ordinal()] = register.registerIcon(alloy.iconKey + "Block");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        meta = MathHelper.clamp_int((int)meta, (int)0, (int)(Alloy.values().length - 1));
        return this.icons[meta];
    }

    public int getDamageValue(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z);
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        return Alloy.values()[world.getBlockMetadata(x, y, z)].getHardness();
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.getBlockHardness(world, x, y, z) * 2.0f;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return true;
    }

    protected boolean shouldWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(EnderIO.lang.localize("tooltip.isBeaconBase"));
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }
}

