/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.enderio.material.ItemFusedQuartz;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFusedQuartz
extends BlockEio {
    public static int renderId;
    private static final Type[] metaMapping;
    IIcon[] blockIcon;
    IIcon[] itemsIcons;
    IIcon[] frameIcons;

    public static BlockFusedQuartz create() {
        BlockFusedQuartz result = new BlockFusedQuartz();
        result.init();
        return result;
    }

    private BlockFusedQuartz() {
        super(ModObject.blockFusedQuartz.unlocalisedName, TileEntityPaintedBlock.class, Material.glass);
        this.setStepSound(Block.soundTypeGlass);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, ItemFusedQuartz.class, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.getBlockMetadata(x, y, z);
        Type type = Type.byMeta(meta);
        if (type.blastResistance) {
            return 2000.0f;
        }
        return super.getExplosionResistance(par1Entity);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return renderId;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        Type type = Type.byMeta(meta);
        return type.lightOpacity;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (block != this) {
            return super.getLightValue(world, x, y, z);
        }
        int meta = world.getBlockMetadata(x, y, z);
        Type type = Type.byMeta(meta);
        return type.enlightened ? 15 : super.getLightValue(world, x, y, z);
    }

    public int damageDropped(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < Type.values().length; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.getBlock(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        if (block == this) {
            BlockCoord here = new BlockCoord(x, y, z).getLocation(ForgeDirection.VALID_DIRECTIONS[side].getOpposite());
            int myMeta = world.getBlockMetadata(here.x, here.y, here.z);
            return !Type.byMeta(myMeta).connectTo(meta);
        }
        return true;
    }

    public boolean isBlockSolid(IBlockAccess p_149747_1_, int p_149747_2_, int p_149747_3_, int p_149747_4_, int p_149747_5_) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    public boolean canPlaceTorchOnTop(World arg0, int arg1, int arg2, int arg3) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        Type[] ts = Type.values();
        this.blockIcon = new IIcon[ts.length];
        this.itemsIcons = new IIcon[ts.length];
        this.frameIcons = new IIcon[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            this.blockIcon[i] = iIconRegister.registerIcon(ts[i].blockIcon);
            this.itemsIcons[i] = iIconRegister.registerIcon(ts[i].itemIcon);
            this.frameIcons[i] = iIconRegister.registerIcon(ts[i].frameIcon);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int meta) {
        meta = MathHelper.clamp_int((int)meta, (int)0, (int)(this.blockIcon.length - 1));
        return this.blockIcon[meta];
    }

    public IIcon getItemIcon(int meta) {
        meta = MathHelper.clamp_int((int)meta, (int)0, (int)(this.itemsIcons.length - 1));
        return this.itemsIcons[meta];
    }

    public IIcon getDefaultFrameIcon(int meta) {
        meta = MathHelper.clamp_int((int)meta, (int)0, (int)(this.frameIcons.length - 1));
        return this.frameIcons[meta];
    }

    protected boolean shouldWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return false;
    }

    static {
        metaMapping = new Type[16];
        Type.GLASS.setConnectedTexture(Type.ENLIGHTENED_GLASS);
        Type.GLASS.setConnectedTexture(Type.DARK_GLASS);
        Type.ENLIGHTENED_GLASS.setConnectedTexture(Type.GLASS);
        Type.ENLIGHTENED_GLASS.setConnectedTexture(Type.DARK_GLASS);
        Type.DARK_GLASS.setConnectedTexture(Type.GLASS);
        Type.DARK_GLASS.setConnectedTexture(Type.ENLIGHTENED_GLASS);
        Type.FUSED_QUARTZ.setConnectedTexture(Type.ENLIGHTENED_FUSED_QUARTZ);
        Type.FUSED_QUARTZ.setConnectedTexture(Type.DARK_FUSED_QUARTZ);
        Type.ENLIGHTENED_FUSED_QUARTZ.setConnectedTexture(Type.FUSED_QUARTZ);
        Type.ENLIGHTENED_FUSED_QUARTZ.setConnectedTexture(Type.DARK_FUSED_QUARTZ);
        Type.DARK_FUSED_QUARTZ.setConnectedTexture(Type.FUSED_QUARTZ);
        Type.DARK_FUSED_QUARTZ.setConnectedTexture(Type.ENLIGHTENED_FUSED_QUARTZ);
    }

    public static enum Type {
        FUSED_QUARTZ("fusedQuartz", "enderio:fusedQuartz", "enderio:fusedQuartzFrame", "enderio:fusedQuartzItem", false, true, 0),
        GLASS("fusedGlass", "enderio:fusedGlass", Config.clearGlassSameTexture ? "enderio:fusedQuartzFrame" : "enderio:fusedGlassFrame", "enderio:fusedGlassItem", false, false, 0),
        ENLIGHTENED_FUSED_QUARTZ("enlightenedFusedQuartz", "enderio:fusedQuartz", "enderio:fusedQuartzFrame", "enderio:fusedQuartzItem", true, true, 0),
        ENLIGHTENED_GLASS("enlightenedFusedGlass", "enderio:fusedGlass", Config.clearGlassSameTexture ? "enderio:fusedQuartzFrame" : "enderio:fusedGlassFrame", "enderio:fusedGlassItem", true, false, 0),
        DARK_FUSED_QUARTZ("darkFusedQuartz", "enderio:fusedQuartz", "enderio:fusedQuartzFrame", "enderio:fusedQuartzItem", false, true, 255),
        DARK_GLASS("darkFusedGlass", "enderio:fusedGlass", Config.clearGlassSameTexture ? "enderio:fusedQuartzFrame" : "enderio:fusedGlassFrame", "enderio:fusedGlassItem", false, false, 255);

        final String unlocalisedName;
        final String blockIcon;
        final String frameIcon;
        final String itemIcon;
        final boolean enlightened;
        final boolean blastResistance;
        final int lightOpacity;
        int connectedTextureMask;

        private Type(String unlocalisedName, String blockIcon, String frameIcon, String itemIcon, boolean enlightened, boolean blastResistance, int lightOpacity) {
            this.unlocalisedName = unlocalisedName;
            this.frameIcon = frameIcon;
            this.blockIcon = blockIcon;
            this.itemIcon = itemIcon;
            this.enlightened = enlightened;
            this.blastResistance = blastResistance;
            this.lightOpacity = lightOpacity;
            this.connectedTextureMask = Config.clearGlassConnectToFusedQuartz ? -1 : 1 << this.ordinal();
            metaMapping[this.ordinal()] = this;
        }

        public boolean connectTo(int otherMeta) {
            return (this.connectedTextureMask & 1 << otherMeta) != 0;
        }

        void setConnectedTexture(Type other) {
            this.connectedTextureMask |= 1 << other.ordinal();
        }

        public static Type byMeta(int meta) {
            return metaMapping[meta] != null ? metaMapping[meta] : GLASS;
        }
    }
}

