/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.TileEntityEnder;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.wireless.PacketStoredEnergy;
import crazypants.enderio.machine.wireless.TileWirelessCharger;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWirelessCharger
extends BlockEio
implements IResourceTooltipProvider {
    public static int renderId = 0;
    private IIcon centerOn;
    private IIcon centerOff;

    public static BlockWirelessCharger create() {
        PacketHandler.INSTANCE.registerMessage(PacketStoredEnergy.class, PacketStoredEnergy.class, PacketHandler.nextID(), Side.CLIENT);
        BlockWirelessCharger res = new BlockWirelessCharger();
        res.init();
        return res;
    }

    protected BlockWirelessCharger() {
        super(ModObject.blockWirelessCharger.unlocalisedName, TileWirelessCharger.class);
        this.setLightOpacity(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        this.centerOn = iIconRegister.registerIcon("enderio:blockWirelessChargerOn");
        this.centerOff = iIconRegister.registerIcon("enderio:blockWirelessChargerOff");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int p_149673_5_) {
        TileWirelessCharger twc;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileWirelessCharger && (twc = (TileWirelessCharger)te).isActive()) {
            return this.centerOn;
        }
        return this.centerOff;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int p_149691_1_, int p_149691_2_) {
        return this.centerOff;
    }

    public IIcon getCenterOn() {
        return this.centerOn;
    }

    public IIcon getCenterOff() {
        return this.centerOff;
    }

    public int getRenderType() {
        return renderId;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName();
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        TileEntity te;
        super.onBlockPlacedBy(world, x, y, z, player, stack);
        if (stack.stackTagCompound != null && (te = world.getTileEntity(x, y, z)) instanceof TileWirelessCharger) {
            ((TileWirelessCharger)te).readCustomNBT(stack.stackTagCompound);
        }
    }

    protected void processDrop(World world, int x, int y, int z, TileEntityEnder te, ItemStack drop) {
        drop.stackTagCompound = new NBTTagCompound();
        if (te instanceof TileWirelessCharger) {
            ((TileWirelessCharger)te).writeCustomNBT(drop.stackTagCompound);
        }
    }
}

