/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.vacuum.ContainerVacuumChest;
import crazypants.enderio.machine.vacuum.PacketVaccumChest;
import crazypants.enderio.machine.vacuum.TileVacuumChest;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class GuiVacuumChest
extends GuiContainerBase {
    private static final int RANGE_LEFT = 145;
    private static final int RANGE_TOP = 86;
    private static final int RANGE_WIDTH = 16;
    private static final int FILTER_LEFT = 29;
    private static final int FILTER_TOP = 85;
    private static final int ID_RANGE_UP = 4711;
    private static final int ID_RANGE_DOWN = 4712;
    private static final int ID_WHITELIST = 4713;
    private static final int ID_MATCHMETA = 4714;
    private static final int ID_REDSTONE = 4715;
    private final TileVacuumChest te;
    private final GuiToolTip rangeTooltip;
    private final MultiIconButton rangeUpB;
    private final MultiIconButton rangeDownB;
    private final ToggleButton whiteListB;
    private final ToggleButton useMetaB;
    private final RedstoneModeButton rsB;
    private final String headerChest;
    private final String headerFilter;
    private final String headerRange;
    private final String headerInventory;

    public GuiVacuumChest(EntityPlayer player, InventoryPlayer inventory, TileVacuumChest te) {
        super((Container)new ContainerVacuumChest(player, inventory, te));
        this.te = te;
        this.ySize = 206;
        int x = 145;
        int y = 86;
        this.rangeTooltip = new GuiToolTip(new Rectangle(x, y, 16, 16), new String[]{EnderIO.lang.localize("gui.vacuum.range")});
        this.rangeUpB = MultiIconButton.createAddButton((IGuiScreen)this, (int)4711, (int)(x += 16), (int)y);
        this.rangeDownB = MultiIconButton.createMinusButton((IGuiScreen)this, (int)4712, (int)x, (int)(y += 8));
        x = this.xSize - 16 - 7;
        y = 104;
        this.rsB = new RedstoneModeButton((IGuiScreen)this, 4715, x, y, te, new BlockCoord((TileEntity)te));
        x = 121;
        y = 86;
        this.whiteListB = new ToggleButton((IGuiScreen)this, 4713, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST, (IWidgetIcon)IconEIO.FILTER_BLACKLIST);
        this.whiteListB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.whitelist")});
        this.whiteListB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.blacklist")});
        this.whiteListB.setPaintSelectedBorder(false);
        this.useMetaB = new ToggleButton((IGuiScreen)this, 4714, x, y += 18, (IWidgetIcon)IconEIO.FILTER_META_OFF, (IWidgetIcon)IconEIO.FILTER_META);
        this.useMetaB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.matchMetaData")});
        this.useMetaB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.ignoreMetaData")});
        this.useMetaB.setPaintSelectedBorder(false);
        for (int i = 0; i < 5; ++i) {
            this.ghostSlots.add(new FilterGhostSlot(i, 29 + i * 18 + 1, 86));
        }
        this.headerChest = EnderIO.lang.localize("gui.vacuum.header.chest");
        this.headerFilter = EnderIO.lang.localize("gui.vacuum.header.filter");
        this.headerRange = EnderIO.lang.localize("gui.vacuum.header.range");
        this.headerInventory = EnderIO.lang.localizeExact("container.inventory");
        ((ContainerVacuumChest)this.inventorySlots).setFilterChangedCB(new Runnable(){

            @Override
            public void run() {
                GuiVacuumChest.this.filterChanged();
            }
        });
    }

    public void initGui() {
        super.initGui();
        this.rangeUpB.onGuiInit();
        this.rangeDownB.onGuiInit();
        this.rsB.onGuiInit();
        this.addToolTip(this.rangeTooltip);
        this.filterChanged();
    }

    public void actionPerformed(GuiButton guiButton) {
        switch (guiButton.id) {
            case 4711: {
                this.setRange(this.te.getRange() + 1);
                break;
            }
            case 4712: {
                this.setRange(this.te.getRange() - 1);
                break;
            }
            case 4713: {
                ItemFilter itemFilter = this.te.getItemFilter();
                if (itemFilter == null) break;
                PacketHandler.INSTANCE.sendToServer((IMessage)PacketVaccumChest.setFilterBlacklist(this.te, !itemFilter.isBlacklist()));
                this.updateButtons();
                break;
            }
            case 4714: {
                ItemFilter itemFilter = this.te.getItemFilter();
                if (itemFilter == null) break;
                PacketHandler.INSTANCE.sendToServer((IMessage)PacketVaccumChest.setFilterMatchMeta(this.te, !itemFilter.isMatchMeta()));
                this.updateButtons();
            }
        }
    }

    private void setRange(int range) {
        PacketHandler.INSTANCE.sendToServer((IMessage)PacketVaccumChest.setRange(this.te, range));
    }

    void setFilterSlot(int slot, ItemStack stack) {
        PacketHandler.INSTANCE.sendToServer((IMessage)PacketVaccumChest.setFilterSlot(this.te, slot, stack));
    }

    void filterChanged() {
        if (this.te.hasItemFilter()) {
            this.whiteListB.onGuiInit();
            this.useMetaB.onGuiInit();
            this.updateButtons();
        } else {
            this.whiteListB.detach();
            this.useMetaB.detach();
        }
    }

    private void updateButtons() {
        ItemFilter itemFilter = this.te.getItemFilter();
        this.whiteListB.setSelected(itemFilter.isBlacklist());
        this.useMetaB.setSelected(itemFilter.isMatchMeta());
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/vacumChest.png");
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        if (this.te.getItemFilter() != null) {
            this.drawTexturedModalRect(sx + 29, sy + 85, 0, 238, 90, 18);
            this.drawGhostSlots(mouseX, mouseY);
        }
        int headerColor = 0x404040;
        FontRenderer fr = this.getFontRenderer();
        fr.drawString(this.headerChest, sx + 7, sy + 6, headerColor);
        fr.drawString(this.headerFilter, sx + 7, sy + 74, headerColor);
        fr.drawString(this.headerRange, sx + this.xSize - 7 - fr.getStringWidth(this.headerRange), sy + 74, headerColor);
        fr.drawString(this.headerInventory, sx + 7, sy + 111, headerColor);
        IconEIO.map.render((IWidgetIcon)EnderWidget.BUTTON_DOWN, (double)(sx + 145), (double)(sy + 86), 16.0, 16.0, 0.0, true);
        String str = Integer.toString(this.te.getRange());
        int sw = fr.getStringWidth(str);
        fr.drawString(str, sx + 145 + 16 - sw - 5, sy + 86 + 5, ColorUtil.getRGB((Color)Color.black));
    }

    class FilterGhostSlot
    extends GhostSlot {
        final int slot;

        FilterGhostSlot(int slot, int x, int y) {
            this.slot = slot;
            this.x = x;
            this.y = y;
        }

        public boolean isVisible() {
            return GuiVacuumChest.this.te.hasItemFilter();
        }

        public void putStack(ItemStack stack) {
            PacketHandler.INSTANCE.sendToServer((IMessage)PacketVaccumChest.setFilterSlot(GuiVacuumChest.this.te, this.slot, stack));
        }

        public ItemStack getStack() {
            ItemFilter itemFilter = GuiVacuumChest.this.te.getItemFilter();
            if (itemFilter != null) {
                return itemFilter.getStackInSlot(this.slot);
            }
            return null;
        }
    }
}

