/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.common.ContainerEnder;
import crazypants.enderio.machine.vacuum.InventoryFilterUpgrade;
import crazypants.enderio.machine.vacuum.TileVacuumChest;
import java.awt.Point;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerVacuumChest
extends ContainerEnder<TileVacuumChest> {
    private Slot filterSlot;
    private Runnable filterChangedCB;

    public ContainerVacuumChest(EntityPlayer player, InventoryPlayer inventory, TileVacuumChest te) {
        super(inventory, (IInventory)te);
    }

    protected void addSlots(InventoryPlayer playerInv) {
        int x = 8;
        int y = 18;
        int index = -1;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot(this.getInv(), ++index, x + j * 18, y + i * 18));
            }
        }
        this.filterSlot = new FilterSlot(new InventoryFilterUpgrade((TileVacuumChest)this.getInv()));
        this.addSlotToContainer(this.filterSlot);
    }

    public Point getPlayerInventoryOffset() {
        Point p = super.getPlayerInventoryOffset();
        p.translate(0, 40);
        return p;
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(par2);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (par2 < 27 ? !this.mergeItemStack(itemstack1, 27, this.inventorySlots.size() - 1, true) : !this.mergeItemStack(itemstack1, 0, 27, false)) {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }

    void setFilterChangedCB(Runnable filterChangedCB) {
        this.filterChangedCB = filterChangedCB;
    }

    void filterChanged() {
        if (this.filterChangedCB != null) {
            this.filterChangedCB.run();
        }
    }

    class FilterSlot
    extends Slot {
        InventoryFilterUpgrade inv;

        FilterSlot(InventoryFilterUpgrade inv) {
            super((IInventory)inv, 0, 8, 86);
            this.inv = inv;
        }

        public void onSlotChanged() {
            ContainerVacuumChest.this.filterChanged();
        }

        public boolean isItemValid(ItemStack stack) {
            return this.inv.isItemValidForSlot(0, stack);
        }
    }
}

