/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.common.Optional;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.gui.ChannelTab;
import crazypants.enderio.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machine.transceiver.gui.FilterTab;
import crazypants.enderio.machine.transceiver.gui.GeneralTab;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiTransceiver
extends GuiPoweredMachineBase<TileTransceiver> {
    private static final int TAB_HEIGHT = 24;
    private int activeTab = 0;
    private final List<ITabPanel> tabs = new ArrayList<ITabPanel>();
    private final int tabYOffset = 4;
    GeneralTab generalTab = new GeneralTab(this);

    public GuiTransceiver(InventoryPlayer par1InventoryPlayer, TileTransceiver te) {
        super(te, (Container)new ContainerTransceiver(par1InventoryPlayer, te));
        this.tabs.add(this.generalTab);
        FilterTab filterTab = new FilterTab(this);
        this.tabs.add(filterTab);
        this.tabs.add(new ChannelTab(this, ChannelType.POWER));
        this.tabs.add(new ChannelTab(this, ChannelType.ITEM));
        this.tabs.add(new ChannelTab(this, ChannelType.FLUID));
        if (Config.enderRailEnabled) {
            this.tabs.add(new ChannelTab(this, ChannelType.RAIL));
        }
    }

    @Override
    protected void updatePowerBarTooltip(List<String> text) {
        this.generalTab.updatePowerBarTooltip(text);
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    public int getXSize() {
        return 256;
    }

    public void updateScreen() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i != this.activeTab) continue;
            this.tabs.get(i).updateScreen();
            return;
        }
    }

    protected void keyTyped(char par1, int par2) {
        if (par2 == 1) {
            for (IGuiOverlay overlay : this.overlays) {
                if (!overlay.isVisible()) continue;
                overlay.setVisible(false);
                return;
            }
            this.mc.thePlayer.closeScreen();
        }
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i != this.activeTab) continue;
            this.tabs.get(i).keyTyped(par1, par2);
            return;
        }
    }

    @Override
    public void initGui() {
        int i;
        super.initGui();
        for (i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) continue;
            this.tabs.get(i).deactivate();
        }
        this.ghostSlots.clear();
        for (i = 0; i < this.tabs.size(); ++i) {
            if (i != this.activeTab) continue;
            this.tabs.get(i).onGuiInit(this.guiLeft + 10, this.guiTop, this.xSize - 20, this.ySize - 20);
        }
        this.configB.visible = this.activeTab == 0;
        this.redstoneButton.visible = this.activeTab == 0;
    }

    @Override
    public void renderPowerBar(int k, int l) {
    }

    @Override
    protected boolean renderPowerBar() {
        return this.activeTab == 0;
    }

    @Override
    public int getPowerX() {
        return super.getPowerX() - 4;
    }

    @Override
    public int getPowerHeight() {
        return 58;
    }

    @Override
    public int getPowerY() {
        return super.getPowerY();
    }

    @Override
    public int getPowerWidth() {
        return 10;
    }

    @Override
    public int getPowerV() {
        return 196;
    }

    @Override
    public int getPowerU() {
        return 246;
    }

    @Override
    public String getPowerOutputLabel() {
        return super.getPowerOutputLabel();
    }

    @Override
    public int getPowerOutputValue() {
        return super.getPowerOutputValue();
    }

    protected void mouseClicked(int x, int y, int par3) {
        super.mouseClicked(x, y, par3);
        int tabLeftX = this.xSize;
        int tabRightX = tabLeftX + 22;
        int minY = 4;
        int maxY = minY + this.tabs.size() * 24;
        if ((x -= this.guiLeft) > tabLeftX && x < tabRightX + 24 && (y -= this.guiTop) > minY && y < maxY) {
            this.activeTab = (y - minY) / 24;
            this.hideOverlays();
            this.initGui();
            return;
        }
        this.tabs.get(this.activeTab).mouseClicked(x, y, par3);
    }

    protected void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        this.tabs.get(this.activeTab).actionPerformed(guiButton);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        int tabX = sx + this.xSize - 3;
        Tessellator tes = Tessellator.instance;
        tes.startDrawingQuads();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) continue;
            RenderUtil.bindTexture((ResourceLocation)IconEIO.TEXTURE);
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)tabX, (double)(sy + 4 + i * 24));
            IWidgetIcon icon = this.tabs.get(i).getIcon();
            icon.getMap().render(icon, (double)(tabX + 4), (double)(sy + 4 + i * 24 + 6), 11.0, 11.0, 0.0, false);
        }
        tes.draw();
        RenderUtil.bindTexture((String)"enderio:textures/gui/transceiver.png");
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((ResourceLocation)IconEIO.TEXTURE);
        tes.startDrawingQuads();
        IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)tabX, (double)(sy + 4 + this.activeTab * 24));
        if (this.tabs.size() > 0) {
            IWidgetIcon icon = this.tabs.get(this.activeTab).getIcon();
            icon.getMap().render(icon, (double)(tabX - 1), (double)(sy + 4 + this.activeTab * 24 + 4));
            tes.draw();
            this.tabs.get(this.activeTab).render(par1, par2, par3);
        } else {
            tes.draw();
        }
    }

    public TileTransceiver getTransciever() {
        return (TileTransceiver)this.getTileEntity();
    }

    public ContainerTransceiver getContainer() {
        return (ContainerTransceiver)this.inventorySlots;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gc, int x, int y, int w, int h) {
        if (this.tabs.size() > 0) {
            int sx = (this.width - this.xSize) / 2;
            int sy = (this.height - this.ySize) / 2;
            int tabX = sx + this.xSize - 3;
            int tabY = sy + 4;
            return x + w >= tabX && x < tabX + 14 && y + h >= tabY && y < tabY + this.tabs.size() * 24;
        }
        return false;
    }
}

